/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.listener_v17;

import com.google.gson.JsonSyntaxException;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.data.EntityData;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.persistence.PersistentDataType;

public class WorldListener_v17
implements Listener {
    private final ModelGenerator generator = ModelEngineAPI.api.getGenerator();

    @EventHandler
    public void onEntityLoad(EntitiesLoadEvent event) {
        if (this.generator.isInitialized()) {
            this.loadEntities(event.getEntities());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.loadEntities(event.getEntities()));
        }
    }

    @EventHandler
    public void onEntityUnload(EntitiesUnloadEvent event) {
        if (this.generator.isInitialized()) {
            this.unloadEntities(event.getEntities());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.unloadEntities(event.getEntities()));
        }
    }

    private void loadEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            String jsonData;
            if (entity instanceof Player || ModelEngineAPI.isModeledEntity(entity.getUniqueId()) || (jsonData = (String)entity.getPersistentDataContainer().get(EntityData.DATA_KEY, PersistentDataType.STRING)) == null) continue;
            try {
                EntityData data = (EntityData)ModelEngineAPI.gson.fromJson(jsonData, EntityData.class);
                ModeledEntity model = ModelEngineAPI.createModeledEntity(entity);
                data.load(model);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            ModeledEntity model;
            if (entity instanceof Player || (model = ModelEngineAPI.getModeledEntity(entity.getUniqueId())) == null) continue;
            EntityData data = new EntityData();
            data.save(model);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson((Object)data));
        }
    }
}

