/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.listener;

import com.google.gson.JsonSyntaxException;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.data.EntityData;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.persistence.PersistentDataType;

public class WorldListener
implements Listener {
    private final ModelGenerator generator = ModelEngineAPI.api.getGenerator();

    @EventHandler
    public void onEntityLoad(ChunkLoadEvent event) {
        if (this.generator.isInitialized()) {
            this.loadEntities(event.getChunk());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.loadEntities(event.getChunk()));
        }
    }

    @EventHandler
    public void onEntityUnload(ChunkUnloadEvent event) {
        if (this.generator.isInitialized()) {
            this.unloadEntities(event.getChunk());
        } else {
            this.generator.queueTask(ModelRegistrationEvent.Phase.POST, () -> this.unloadEntities(event.getChunk()));
        }
    }

    private void loadEntities(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            String jsonData;
            if (entity instanceof Player || ModelEngineAPI.isModeledEntity(entity.getUniqueId()) || (jsonData = (String)entity.getPersistentDataContainer().get(EntityData.DATA_KEY, PersistentDataType.STRING)) == null) continue;
            try {
                EntityData data = (EntityData)ModelEngineAPI.gson.fromJson(jsonData, EntityData.class);
                ModeledEntity model = ModelEngineAPI.createModeledEntity(entity);
                data.load(model);
            }
            catch (JsonSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadEntities(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            ModeledEntity model;
            if (entity instanceof Player || (model = ModelEngineAPI.getModeledEntity(entity.getUniqueId())) == null) continue;
            EntityData data = new EntityData();
            data.save(model);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson((Object)data));
        }
    }
}

