/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.listener;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class EntityListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity;
        if (event.isCancelled() || !((entity = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        UUID id = mob.getUniqueId();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(id);
        if (model == null) {
            return;
        }
        model.hurt();
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        UUID id = event.getEntity().getUniqueId();
        ModeledEntity model = ModelEngineAPI.getModeledEntity(id);
        if (model == null) {
            return;
        }
        Entity damager = event.getDamager();
        MountManager mountHandler = model.getMountManager();
        event.setCancelled(mountHandler.hasRider(damager) && mountHandler.isDamageNullified(damager.getUniqueId()));
    }
}

