/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.generator.parser.ModelParser;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.generator.ModelGeneratorImpl;
import com.ticxo.modelengine.generator.java.JavaItemModel;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchDeserializer;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchPackage;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Locale;
import javax.imageio.ImageIO;

public class BlockbenchParser
implements ModelParser {
    private final ModelGeneratorImpl generator;
    private final Gson gson;

    public BlockbenchParser(ModelGeneratorImpl generator) {
        this.generator = generator;
        this.gson = new GsonBuilder().registerTypeAdapter(BlockbenchPackage.class, (Object)new BlockbenchDeserializer(generator)).create();
    }

    @Override
    public boolean validateFile(File file) {
        return TFile.isExtension(file.getName(), "bbmodel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelBlueprint generate(File file) throws Exception {
        BlockbenchPackage bbp;
        String modelName = TFile.removeExtension(file.getName()).toLowerCase(Locale.ENGLISH);
        try (FileReader reader = new FileReader(file);){
            bbp = (BlockbenchPackage)this.gson.fromJson((Reader)reader, BlockbenchPackage.class);
        }
        String namespace = ConfigProperty.NAMESPACE.getString();
        for (String id : bbp.getModelCache().keySet()) {
            JavaItemModel model = bbp.getModelCache().get(id);
            this.generator.getBaseItem().addModel(namespace + ":" + modelName + "/" + id);
            bbp.getBlueprint().getItemIds().put(id, this.generator.getBaseItem().getData());
            File json = TFile.createFile(this.generator.getModelFolder(), modelName, id + ".json");
            FileWriter writer = new FileWriter(json);
            writer.write(this.gson.toJson((Object)model));
            writer.close();
        }
        for (BlockbenchTexture texture : bbp.getTexturesCache()) {
            if (texture.getNamespace().equals("minecraft")) continue;
            File customDir = texture.getNamespace().equals(namespace) ? this.generator.getTextureFolder() : TFile.createDirectory(this.generator.getPackFolder(), "assets", texture.getNamespace(), "textures", texture.getFolder());
            File tex = TFile.createFile(customDir, texture.getName() + ".png");
            BufferedImage image = TFile.toImage(texture.getSource());
            ImageIO.write((RenderedImage)image, "png", tex);
            String meta = texture.getMcmeta();
            if (meta == null) continue;
            File mcmetaFile = TFile.createFile(this.generator.getTextureFolder(), texture.getName() + ".png.mcmeta");
            FileWriter metaWriter = new FileWriter(mcmetaFile);
            metaWriter.write(meta);
            metaWriter.close();
        }
        bbp.getBlueprint().setModelId(modelName);
        return bbp.getBlueprint();
    }
}

