/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.error.WarnBadTranslation;
import com.ticxo.modelengine.api.error.WarnBoneTooLarge;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.generator.java.JavaItemModel;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BlockbenchPackage {
    private final ModelBlueprint blueprint;
    private final List<BlockbenchTexture> texturesCache = Lists.newArrayList();
    private final Map<String, JavaItemModel> modelCache = new LinkedHashMap<String, JavaItemModel>();

    public void cleanUpElements() {
        for (JavaItemModel model : this.modelCache.values()) {
            model.normalizeModel(new WarnBoneTooLarge(model.getName()), new WarnBadTranslation(model.getName()));
            model.cleanUpTextures();
        }
    }

    public BlockbenchPackage(ModelBlueprint blueprint) {
        this.blueprint = blueprint;
    }

    public ModelBlueprint getBlueprint() {
        return this.blueprint;
    }

    public List<BlockbenchTexture> getTexturesCache() {
        return this.texturesCache;
    }

    public Map<String, JavaItemModel> getModelCache() {
        return this.modelCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockbenchPackage)) {
            return false;
        }
        BlockbenchPackage other = (BlockbenchPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModelBlueprint this$blueprint = this.getBlueprint();
        ModelBlueprint other$blueprint = other.getBlueprint();
        if (this$blueprint == null ? other$blueprint != null : !this$blueprint.equals(other$blueprint)) {
            return false;
        }
        List<BlockbenchTexture> this$texturesCache = this.getTexturesCache();
        List<BlockbenchTexture> other$texturesCache = other.getTexturesCache();
        if (this$texturesCache == null ? other$texturesCache != null : !((Object)this$texturesCache).equals(other$texturesCache)) {
            return false;
        }
        Map<String, JavaItemModel> this$modelCache = this.getModelCache();
        Map<String, JavaItemModel> other$modelCache = other.getModelCache();
        return !(this$modelCache == null ? other$modelCache != null : !((Object)this$modelCache).equals(other$modelCache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockbenchPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModelBlueprint $blueprint = this.getBlueprint();
        result = result * 59 + ($blueprint == null ? 43 : $blueprint.hashCode());
        List<BlockbenchTexture> $texturesCache = this.getTexturesCache();
        result = result * 59 + ($texturesCache == null ? 43 : ((Object)$texturesCache).hashCode());
        Map<String, JavaItemModel> $modelCache = this.getModelCache();
        result = result * 59 + ($modelCache == null ? 43 : ((Object)$modelCache).hashCode());
        return result;
    }

    public String toString() {
        return "BlockbenchPackage(blueprint=" + this.getBlueprint() + ", texturesCache=" + this.getTexturesCache() + ", modelCache=" + this.getModelCache() + ")";
    }
}

