/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.ParticleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.SoundKeyframe;
import com.ticxo.modelengine.api.animation.timeline.Timeline;
import com.ticxo.modelengine.api.error.ErrorBadTexture;
import com.ticxo.modelengine.api.error.ErrorNoFaceCube;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.error.WarnBadNamespace;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.generator.java.JavaItemModel;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchPackage;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchElement;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchFace;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class BlockbenchDeserializer
implements JsonDeserializer<BlockbenchPackage> {
    private static final String[] faceDirections = new String[]{"north", "east", "south", "west", "up", "down"};
    private final ModelGenerator generator;
    private final Map<String, String> mcmetas = Maps.newConcurrentMap();
    private final Map<String, BlockbenchElement> elementsCache = Maps.newConcurrentMap();
    private double uvWidthRatio;
    private double uvHeightRatio;

    public BlockbenchDeserializer(ModelGenerator generator) {
        this.generator = generator;
    }

    public BlockbenchPackage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BlockbenchPackage bbp = new BlockbenchPackage(new ModelBlueprint());
        JsonObject jsonObject = json.getAsJsonObject();
        JsonObject resolution = jsonObject.getAsJsonObject("resolution");
        this.uvWidthRatio = 16.0 / resolution.get("width").getAsDouble();
        this.uvHeightRatio = 16.0 / resolution.get("height").getAsDouble();
        boolean isBoxUV = jsonObject.getAsJsonObject("meta").get("box_uv").getAsBoolean();
        if (isBoxUV) {
            IError.BOX_UV.log();
        }
        this.readElements(jsonObject);
        this.readMCMetas(jsonObject);
        this.readTextures(jsonObject, bbp);
        this.readOutliner(jsonObject, bbp);
        this.readAnimationPlaceholder(jsonObject, bbp);
        this.readAnimations(jsonObject, bbp);
        bbp.cleanUpElements();
        this.mcmetas.clear();
        this.elementsCache.clear();
        if (bbp.getBlueprint().getMainHitbox() == null) {
            IError.NO_HITBOX.log();
        } else if (bbp.getBlueprint().getMainHitbox().getEyeHeight() <= 0.0) {
            IError.BAD_EYE_HEIGHT.log();
        }
        return bbp;
    }

    private void readElements(JsonObject jsonObject) {
        if (!jsonObject.has("elements")) {
            return;
        }
        JsonArray elements = jsonObject.getAsJsonArray("elements");
        for (JsonElement e : elements) {
            String type;
            JsonObject obj = e.getAsJsonObject();
            String string = type = obj.has("type") ? obj.get("type").getAsString() : null;
            if (type != null && !type.equals("cube")) continue;
            String uuid = obj.get("uuid").getAsString();
            String name = obj.get("name").getAsString();
            JsonArray fromArray = obj.get("from").getAsJsonArray();
            JsonArray toArray = obj.get("to").getAsJsonArray();
            JsonArray originArray = obj.get("origin").getAsJsonArray();
            double inflate = obj.has("inflate") ? obj.get("inflate").getAsDouble() : 0.0;
            Vector from = new Vector(fromArray.get(0).getAsDouble(), fromArray.get(1).getAsDouble(), fromArray.get(2).getAsDouble());
            Vector to = new Vector(toArray.get(0).getAsDouble(), toArray.get(1).getAsDouble(), toArray.get(2).getAsDouble());
            Vector origin = new Vector(originArray.get(0).getAsDouble(), originArray.get(1).getAsDouble(), originArray.get(2).getAsDouble());
            EulerAngle rotation = EulerAngle.ZERO;
            if (obj.has("rotation")) {
                JsonArray rotationArray = obj.get("rotation").getAsJsonArray();
                rotation = TMath.makeAngle(rotationArray.get(0).getAsDouble(), rotationArray.get(1).getAsDouble(), rotationArray.get(2).getAsDouble());
            }
            BlockbenchElement element = new BlockbenchElement();
            element.setName(name);
            element.setFrom(from);
            element.setTo(to);
            element.setRotation(rotation);
            element.setOrigin(origin);
            element.setInflate(inflate);
            JsonObject faces = obj.getAsJsonObject("faces");
            for (String dir : faceDirections) {
                double y2;
                double x2;
                double y1;
                JsonObject faceObject;
                JsonArray uv;
                double x1;
                if (!faces.has(dir) || this.isZeroUV(x1 = (uv = (faceObject = faces.getAsJsonObject(dir)).get("uv").getAsJsonArray()).get(0).getAsDouble() * this.uvWidthRatio, y1 = uv.get(1).getAsDouble() * this.uvHeightRatio, x2 = uv.get(2).getAsDouble() * this.uvWidthRatio, y2 = uv.get(3).getAsDouble() * this.uvHeightRatio)) continue;
                Integer uvRot = this.getUVRot(faceObject, "rotation", 0);
                Integer texture = this.getUVRot(faceObject, "texture", null);
                BlockbenchFace face = new BlockbenchFace(x1, y1, x2, y2, uvRot, texture);
                element.getFaces().put(dir, face);
            }
            this.elementsCache.put(uuid, element);
        }
    }

    private boolean isZeroUV(double x1, double y1, double x2, double y2) {
        return Math.abs(x2 - x1) < 1.0E-5 && Math.abs(y2 - y1) < 1.0E-5;
    }

    private Integer getUVRot(JsonObject jsonObject, String field, Integer def) {
        if (!jsonObject.has(field)) {
            return def;
        }
        JsonElement f = jsonObject.get(field);
        if (f.isJsonNull()) {
            return def;
        }
        return f.getAsInt();
    }

    private void readTextures(JsonObject jsonObject, BlockbenchPackage bbp) {
        if (!jsonObject.has("textures")) {
            return;
        }
        JsonArray textures = jsonObject.getAsJsonArray("textures");
        for (JsonElement t : textures) {
            JsonObject obj = t.getAsJsonObject();
            String name = TFile.removeExtension(obj.get("name").getAsString()).toLowerCase(Locale.ENGLISH).trim().toLowerCase(Locale.ENGLISH);
            if (name.matches(".*[^a-z0-9_.-].*")) {
                new ErrorBadTexture(name).log();
            }
            String folder = obj.get("folder").getAsString().toLowerCase(Locale.ENGLISH);
            String namespace = obj.get("namespace").getAsString().toLowerCase(Locale.ENGLISH);
            String uuid = obj.get("uuid").getAsString();
            String source = obj.get("source").getAsString();
            if (namespace.isEmpty() || namespace.equalsIgnoreCase(this.generator.getNamespace())) {
                namespace = this.generator.getNamespace();
                folder = "entity";
            } else if (namespace.matches(".*[^a-z0-9_.-].*")) {
                new WarnBadNamespace(namespace).log();
                namespace = this.generator.getNamespace();
                folder = "entity";
            }
            BlockbenchTexture texture = new BlockbenchTexture(name, folder, namespace, source);
            texture.setMcmeta(this.mcmetas.get(uuid));
            bbp.getTexturesCache().add(texture);
        }
    }

    private void readMCMetas(JsonObject jsonObject) {
        if (!jsonObject.has("mcmetas")) {
            return;
        }
        JsonElement meta = jsonObject.get("mcmetas");
        if (meta.isJsonObject()) {
            JsonObject object = meta.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                String uuid = (String)entry.getKey();
                String data = ((JsonElement)entry.getValue()).toString();
                this.mcmetas.put(uuid, data);
            }
        }
    }

    private void readOutliner(JsonObject jsonObject, BlockbenchPackage bbp) {
        if (!jsonObject.has("outliner")) {
            return;
        }
        JsonArray outlines = jsonObject.getAsJsonArray("outliner");
        for (JsonElement o : outlines) {
            JsonObject outline;
            BlueprintBone bone;
            if (!o.isJsonObject() || (bone = this.readBone(outline = o.getAsJsonObject(), bbp)) == null) continue;
            bbp.getBlueprint().getBones().put(bone.getName(), bone);
            bbp.getBlueprint().getFinalBoneNames().put(bone.getUuid(), bone.getName());
        }
    }

    @Nullable
    private BlueprintBone readBone(JsonObject outline, BlockbenchPackage bbp) {
        JsonElement c;
        JsonArray children;
        JsonElement c2;
        JsonArray children2;
        String name = outline.get("name").getAsString().toLowerCase(Locale.ENGLISH);
        JsonArray originArray = outline.get("origin").getAsJsonArray();
        Vector itemOrigin = new Vector(originArray.get(0).getAsDouble(), originArray.get(1).getAsDouble(), originArray.get(2).getAsDouble());
        Vector origin = new Vector(-itemOrigin.getX(), itemOrigin.getY(), -itemOrigin.getZ()).multiply(0.0625);
        EulerAngle rotation = EulerAngle.ZERO;
        UUID uuid = UUID.fromString(outline.get("uuid").getAsString());
        if (outline.has("rotation")) {
            JsonArray rotationArray = outline.get("rotation").getAsJsonArray();
            rotation = TMath.makeAngle(-rotationArray.get(0).getAsDouble(), -rotationArray.get(1).getAsDouble(), rotationArray.get(2).getAsDouble());
        }
        if (name.equalsIgnoreCase("hitbox") && (children2 = outline.get("children").getAsJsonArray()).size() > 0 && !(c2 = children2.get(0)).isJsonObject()) {
            String cube = c2.getAsString();
            bbp.getBlueprint().setMainHitbox(this.buildHitbox(cube, origin.getY()));
            return null;
        }
        BlueprintBone bone = new BlueprintBone();
        bone.setName(name);
        bone.setItemOrigin(itemOrigin);
        bone.setGlobalOrigin(origin);
        bone.setLocalOrigin(origin);
        bone.setLocalRotation(rotation);
        bone.setUuid(uuid);
        if (name.startsWith("h_")) {
            name = name.substring(2);
            bone.setOption("head");
            bone.setName(name);
        }
        if (name.startsWith("g_")) {
            name = name.substring(2);
            bone.setOption("ghost");
            bone.setName(name);
        }
        if (name.equalsIgnoreCase("mount")) {
            bone.setOption("mount");
            return bone;
        }
        if (name.startsWith("b_") && (children = outline.get("children").getAsJsonArray()).size() > 0 && !(c = children.get(0)).isJsonObject()) {
            String cube = c.getAsString();
            bbp.getBlueprint().getSubHitboxes().put(name, this.buildHitbox(cube, origin.getY()));
            bone.setGlobalOrigin(this.getCubeCenter(cube));
            bone.setOption("sub_aabb");
            return bone;
        }
        if (name.startsWith("ob_") && (children = outline.get("children").getAsJsonArray()).size() > 0 && !(c = children.get(0)).isJsonObject()) {
            String cube = c.getAsString();
            bbp.getBlueprint().getSubHitboxes().put(name, this.buildHitbox(cube, origin.getY()));
            bone.setGlobalOrigin(this.getCubeCenter(cube));
            bone.setOption("sub_obb");
            return bone;
        }
        String[] tags = name.split("_");
        block18: for (int i = 0; i < tags.length - 1; ++i) {
            String tag;
            switch (tag = tags[i]) {
                case "tag": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(4);
                    bone.setOption("tag");
                    continue block18;
                }
                case "p": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(2);
                    bone.setOption("seat");
                    continue block18;
                }
                case "ir": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(3);
                    bone.setString("item", "main_hand");
                    continue block18;
                }
                case "il": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(3);
                    bone.setString("item", "off_hand");
                    continue block18;
                }
                case "ih": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(3);
                    bone.setString("item", "head");
                    continue block18;
                }
                case "seg": {
                    name = name.substring(4);
                    bone.setOption("segment");
                    continue block18;
                }
                case "l": {
                    if (bone.isHasModel()) break block18;
                    name = name.substring(2);
                    bone.setOption("leash");
                    continue block18;
                }
            }
        }
        bone.setName(name);
        JsonArray children3 = outline.get("children").getAsJsonArray();
        for (JsonElement c3 : children3) {
            BlockbenchElement element;
            if (c3.isJsonObject()) {
                BlueprintBone child = this.readBone(c3.getAsJsonObject(), bbp);
                if (child == null) continue;
                bbp.getBlueprint().getFinalBoneNames().put(child.getUuid(), child.getName());
                child.setLocalOrigin(child.getGlobalOrigin().clone().subtract(bone.getGlobalOrigin()));
                bone.getChildren().add(child);
                continue;
            }
            String child = c3.getAsString();
            JavaItemModel itemModel = bbp.getModelCache().get(name);
            if (itemModel == null) {
                itemModel = new JavaItemModel(name, bbp.getTexturesCache(), bone);
                bone.setHasModel(true);
                bbp.getModelCache().put(name, itemModel);
            }
            if ((element = this.elementsCache.get(child)) == null) continue;
            if (element.getFaces().isEmpty()) {
                new ErrorNoFaceCube(name, element.getName()).log();
                continue;
            }
            itemModel.addElement(element);
        }
        return bone;
    }

    private void readAnimationPlaceholder(JsonObject jsonObject, BlockbenchPackage bbp) {
        String[] placeholders;
        if (!jsonObject.has("animation_variable_placeholders")) {
            return;
        }
        for (String placeholder : placeholders = jsonObject.get("animation_variable_placeholders").getAsString().split("\n")) {
            String[] entry = placeholder.split("=", 2);
            bbp.getBlueprint().getAnimationsPlaceholders().put(entry[0], entry.length == 2 ? entry[1] : "");
        }
    }

    private void readAnimations(JsonObject jsonObject, BlockbenchPackage bbp) {
        if (!jsonObject.has("animations")) {
            return;
        }
        JsonArray animations = jsonObject.getAsJsonArray("animations");
        for (JsonElement a : animations) {
            JsonObject obj = a.getAsJsonObject();
            String name = obj.get("name").getAsString().toLowerCase(Locale.ENGLISH);
            BlueprintAnimation animation = new BlueprintAnimation(name);
            if (obj.has("loop")) {
                animation.setLoopMode(LoopMode.get(obj.get("loop").getAsString()));
            }
            if (obj.has("override")) {
                animation.setOverride(obj.get("override").getAsBoolean());
            }
            if (obj.has("length")) {
                animation.setLength(obj.get("length").getAsFloat());
            }
            if (obj.has("animators")) {
                JsonObject animators = obj.get("animators").getAsJsonObject();
                for (Map.Entry entry : animators.entrySet()) {
                    String boneName;
                    String type;
                    String key = (String)entry.getKey();
                    JsonObject bone = ((JsonElement)entry.getValue()).getAsJsonObject();
                    if ("effects".equals(key)) {
                        Timeline timeline = animation.getOrCreateTimeline("effects");
                        this.configureEffectsTimeline(timeline, bone.get("keyframes"));
                        continue;
                    }
                    UUID uuid = UUID.fromString(key);
                    String string = type = bone.has("type") ? bone.get("type").getAsString() : null;
                    if (type != null && !"bone".equals(type) || (boneName = bbp.getBlueprint().getFinalBoneNames().get(uuid)) == null) continue;
                    Timeline timeline = animation.getOrCreateTimeline(boneName);
                    this.configureTimeline(timeline, bone.get("keyframes"), bbp);
                }
            }
            bbp.getBlueprint().getAnimations().put(name, animation);
        }
    }

    private void configureTimeline(Timeline timeline, JsonElement element, BlockbenchPackage bbp) {
        JsonArray keyframes = element.getAsJsonArray();
        for (JsonElement ele : keyframes) {
            JsonObject key = ele.getAsJsonObject();
            if (!key.has("channel") || !key.has("data_points") || !key.has("time")) continue;
            String channel = key.get("channel").getAsString();
            JsonObject data = key.get("data_points").getAsJsonArray().get(0).getAsJsonObject();
            double[] values = new double[]{TMath.tryParse(this.getPlaceholderValue(data.get("x").getAsString(), bbp), 0.0), TMath.tryParse(this.getPlaceholderValue(data.get("y").getAsString(), bbp), 0.0), TMath.tryParse(this.getPlaceholderValue(data.get("z").getAsString(), bbp), 0.0)};
            double time = key.get("time").getAsDouble();
            KeyframeType type = this.getType(key.get("interpolation").getAsString());
            switch (channel) {
                case "rotation": {
                    timeline.addRotationFrame(time, TMath.makeAngle(values[0], values[1], values[2]), type);
                    break;
                }
                case "position": {
                    timeline.addPositionFrame(time, new Vector(values[0], values[1], -values[2]).multiply(0.0625), type);
                    break;
                }
                case "scale": {
                    timeline.addScaleFrame(time, new Vector(values[0], values[1], values[2]), type);
                }
            }
        }
    }

    private void configureEffectsTimeline(Timeline timeline, JsonElement element) {
        JsonArray keyframes = element.getAsJsonArray();
        for (JsonElement ele : keyframes) {
            JsonObject key = ele.getAsJsonObject();
            if (!key.has("channel") || !key.has("data_points") || !key.has("time")) continue;
            String channel = key.get("channel").getAsString();
            JsonArray data = key.get("data_points").getAsJsonArray();
            double time = key.get("time").getAsDouble();
            switch (channel) {
                case "particle": {
                    ArrayList<ParticleKeyframe.Particles> particles = new ArrayList<ParticleKeyframe.Particles>();
                    for (JsonElement particle : data) {
                        JsonObject particleData = particle.getAsJsonObject();
                        String effect = particleData.get("effect").getAsString();
                        String locator = particleData.get("locator").getAsString();
                        particles.add(new ParticleKeyframe.Particles(effect, locator));
                    }
                    timeline.addParticleFrame(time, particles);
                    break;
                }
                case "sound": {
                    ArrayList<SoundKeyframe.Sounds> sounds = new ArrayList<SoundKeyframe.Sounds>();
                    for (JsonElement soundData : data) {
                        String effect = soundData.getAsJsonObject().get("effect").getAsString();
                        sounds.add(new SoundKeyframe.Sounds(effect));
                    }
                    timeline.addSoundFrame(time, sounds);
                    break;
                }
                case "timeline": {
                    JsonObject scriptData = data.get(0).getAsJsonObject();
                    String[] lines = scriptData.get("script").getAsString().split("\n");
                    ArrayList<ScriptKeyframe.Script> scripts = new ArrayList<ScriptKeyframe.Script>();
                    for (String line : lines) {
                        String[] value = line.split(":", 2);
                        if (value.length == 1) {
                            scripts.add(new ScriptKeyframe.Script(null, value[0]));
                            continue;
                        }
                        scripts.add(new ScriptKeyframe.Script(value[0], value[1]));
                    }
                    timeline.addScriptFrame(time, scripts);
                }
            }
        }
    }

    private KeyframeType getType(String type) {
        return switch (type.toLowerCase(Locale.ENGLISH)) {
            case "catmullrom" -> KeyframeType.SMOOTH;
            case "step" -> KeyframeType.STEP;
            default -> KeyframeType.LINEAR;
        };
    }

    private Hitbox buildHitbox(String uuid, double eyeHeight) {
        BlockbenchElement ele = this.elementsCache.get(uuid);
        double x = (ele.getTo().getX() - ele.getFrom().getX()) / 16.0;
        double y = (ele.getTo().getY() - ele.getFrom().getY()) / 16.0;
        double z = (ele.getTo().getZ() - ele.getFrom().getZ()) / 16.0;
        return new Hitbox(x, y, z, eyeHeight);
    }

    private Vector getCubeCenter(String uuid) {
        BlockbenchElement ele = this.elementsCache.get(uuid);
        double x = (ele.getTo().getX() + ele.getFrom().getX()) / 32.0;
        double y = (ele.getTo().getY() + ele.getFrom().getY()) / 32.0;
        double z = (ele.getTo().getZ() + ele.getFrom().getZ()) / 32.0;
        return new Vector(-x, y, -z);
    }

    private String getPlaceholderValue(String placeholder, BlockbenchPackage bbp) {
        return bbp.getBlueprint().getAnimationsPlaceholders().getOrDefault(placeholder, placeholder);
    }
}

