/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.java;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.error.WarnBadAngle;
import com.ticxo.modelengine.api.error.WarnBadTranslation;
import com.ticxo.modelengine.api.error.WarnBoneTooLarge;
import com.ticxo.modelengine.api.error.WarnMultipleAngle;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchElement;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchFace;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class JavaItemModel {
    private final transient String name;
    private final Map<Integer, String> textures = Maps.newConcurrentMap();
    private final List<JavaCube> elements = new ArrayList<JavaCube>();
    private final Map<String, JavaDisplay> display = Maps.newConcurrentMap();
    private final transient JavaDisplay head;
    private final transient Set<Integer> usedTexture = Sets.newConcurrentHashSet();
    private final transient BlueprintBone bone;

    public JavaItemModel(String name, List<BlockbenchTexture> texturesCache, BlueprintBone bone) {
        this.name = name;
        int i = 0;
        for (BlockbenchTexture texture : texturesCache) {
            this.textures.put(i++, texture.getNamespace() + ":" + texture.getFolder() + "/" + texture.getName());
        }
        this.bone = bone;
        this.head = new JavaDisplay();
        this.display.put("head", this.head);
    }

    public void addElement(BlockbenchElement element) {
        JavaCube cube = new JavaCube();
        cube.setFrom(element.getFrom().clone().subtract(this.bone.getItemOrigin()));
        cube.setTo(element.getTo().clone().subtract(this.bone.getItemOrigin()));
        cube.inflate(element.getInflate());
        JavaRotation rotation = new JavaRotation();
        rotation.setRotation(element.getRotation(), new WarnMultipleAngle(this.name, element.getName()), new WarnBadAngle(this.name, element.getName()));
        rotation.setOrigin(element.getOrigin().clone().subtract(this.bone.getItemOrigin()));
        cube.setRotation(rotation);
        for (String dir : element.getFaces().keySet()) {
            BlockbenchFace face = element.getFaces().get(dir);
            if (face.getTexture() != null) {
                this.usedTexture.add(face.getTexture());
            }
            cube.getFaces().put(dir, new JavaFace(face));
        }
        this.elements.add(cube);
    }

    public void shrinkModel(double ratio) {
        for (JavaCube cube : this.elements) {
            cube.shrink(ratio);
        }
    }

    public void offsetModel(float x, float y, float z) {
        for (JavaCube cube : this.elements) {
            cube.offset(x, y, z);
        }
    }

    public void normalizeModel(WarnBoneTooLarge sizeWarning, WarnBadTranslation offsetWarning) {
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        for (JavaCube cube : this.elements) {
            float[] from = cube.getFrom();
            float[] to = cube.getTo();
            minX = Math.min(minX, from[0]);
            minY = Math.min(minY, from[1]);
            minZ = Math.min(minZ, from[2]);
            maxX = Math.max(maxX, to[0]);
            maxY = Math.max(maxY, to[1]);
            maxZ = Math.max(maxZ, to[2]);
        }
        float sizeX = maxX - minX;
        float sizeY = maxY - minY;
        float sizeZ = maxZ - minZ;
        float ratio = 0.5714286f;
        if (sizeX > 84.0f || sizeY > 84.0f || sizeZ > 84.0f) {
            this.bone.setOption("large");
            ratio = 0.4f;
        }
        this.shrinkModel(ratio);
        minX *= ratio;
        minY *= ratio;
        minZ *= ratio;
        maxX *= ratio;
        maxY *= ratio;
        maxZ *= ratio;
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float offsetZ = 0.0f;
        offsetX += minX < -24.0f ? -24.0f - minX : 0.0f;
        offsetY += minY < -24.0f ? -24.0f - minY : 0.0f;
        offsetZ += minZ < -24.0f ? -24.0f - minZ : 0.0f;
        this.offsetModel(offsetX += maxX > 24.0f ? 24.0f - maxX : 0.0f, offsetY += maxY > 24.0f ? 24.0f - maxY : 0.0f, offsetZ += maxZ > 24.0f ? 24.0f - maxZ : 0.0f);
        this.head.offsetTranslation(offsetX, offsetY, offsetZ);
        this.offsetModel(8.0f, 8.0f, 8.0f);
        if (sizeX > 120.0f || sizeY > 120.0f || sizeZ > 120.0f) {
            sizeWarning.setX(sizeX);
            sizeWarning.setY(sizeY);
            sizeWarning.setZ(sizeZ);
            sizeWarning.log();
        } else if (Math.abs(this.head.translation[0]) > 80.0f || Math.abs(this.head.translation[1]) > 80.0f || Math.abs(this.head.translation[2]) > 80.0f) {
            offsetWarning.setX(this.head.translation[0]);
            offsetWarning.setY(this.head.translation[1]);
            offsetWarning.setZ(this.head.translation[2]);
            offsetWarning.log();
        }
    }

    public void cleanUpTextures() {
        for (int id : this.textures.keySet()) {
            if (this.usedTexture.contains(id)) continue;
            this.textures.remove(id);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<Integer, String> getTextures() {
        return this.textures;
    }

    public List<JavaCube> getElements() {
        return this.elements;
    }

    public Map<String, JavaDisplay> getDisplay() {
        return this.display;
    }

    public JavaDisplay getHead() {
        return this.head;
    }

    public Set<Integer> getUsedTexture() {
        return this.usedTexture;
    }

    public BlueprintBone getBone() {
        return this.bone;
    }

    static class JavaDisplay {
        private final float[] translation = new float[]{0.0f, -6.4f, 0.0f};
        private final float[] scale = new float[]{4.0f, 4.0f, 4.0f};

        JavaDisplay() {
        }

        public void offsetTranslation(double x, double y, double z) {
            this.translation[0] = (float)((double)this.translation[0] - x * (double)this.scale[0]);
            this.translation[1] = (float)((double)this.translation[1] - y * (double)this.scale[1]);
            this.translation[2] = (float)((double)this.translation[2] - z * (double)this.scale[2]);
        }

        public float[] getTranslation() {
            return this.translation;
        }

        public float[] getScale() {
            return this.scale;
        }
    }

    static class JavaCube {
        private final float[] from = new float[3];
        private final float[] to = new float[3];
        private JavaRotation rotation;
        private final Map<String, JavaFace> faces = Maps.newConcurrentMap();

        JavaCube() {
        }

        private void setFrom(Vector from) {
            this.from[0] = (float)from.getX();
            this.from[1] = (float)from.getY();
            this.from[2] = (float)from.getZ();
        }

        private void setTo(Vector to) {
            this.to[0] = (float)to.getX();
            this.to[1] = (float)to.getY();
            this.to[2] = (float)to.getZ();
        }

        private void inflate(double inflate) {
            this.from[0] = (float)((double)this.from[0] - inflate);
            this.from[1] = (float)((double)this.from[1] - inflate);
            this.from[2] = (float)((double)this.from[2] - inflate);
            this.to[0] = (float)((double)this.to[0] + inflate);
            this.to[1] = (float)((double)this.to[1] + inflate);
            this.to[2] = (float)((double)this.to[2] + inflate);
        }

        private void shrink(double ratio) {
            this.from[0] = (float)((double)this.from[0] * ratio);
            this.from[1] = (float)((double)this.from[1] * ratio);
            this.from[2] = (float)((double)this.from[2] * ratio);
            this.to[0] = (float)((double)this.to[0] * ratio);
            this.to[1] = (float)((double)this.to[1] * ratio);
            this.to[2] = (float)((double)this.to[2] * ratio);
            if (this.rotation != null) {
                this.rotation.shrink(ratio);
            }
        }

        private void offset(float x, float y, float z) {
            this.from[0] = this.from[0] + x;
            this.from[1] = this.from[1] + y;
            this.from[2] = this.from[2] + z;
            this.to[0] = this.to[0] + x;
            this.to[1] = this.to[1] + y;
            this.to[2] = this.to[2] + z;
            if (this.rotation != null) {
                this.rotation.offset(x, y, z);
            }
        }

        public float[] getFrom() {
            return this.from;
        }

        public float[] getTo() {
            return this.to;
        }

        public JavaRotation getRotation() {
            return this.rotation;
        }

        public Map<String, JavaFace> getFaces() {
            return this.faces;
        }

        public void setRotation(JavaRotation rotation) {
            this.rotation = rotation;
        }
    }

    static class JavaRotation {
        private float angle;
        private String axis;
        private final float[] origin = new float[3];

        JavaRotation() {
        }

        private void setRotation(EulerAngle rotation, WarnMultipleAngle warnMultipleAngle, WarnBadAngle warnBadAngle) {
            double x = Math.abs(rotation.getX());
            double y = Math.abs(rotation.getY());
            double z = Math.abs(rotation.getZ());
            if (x > 0.0 && y > 0.0 || z > 0.0 && y > 0.0 || x > 0.0 && z > 0.0) {
                warnMultipleAngle.log();
            }
            if (x > y) {
                if (x > z) {
                    this.angle = (float)Math.toDegrees(rotation.getX());
                    this.axis = "x";
                } else {
                    this.angle = (float)Math.toDegrees(rotation.getZ());
                    this.axis = "z";
                }
            } else if (z > y) {
                this.angle = (float)Math.toDegrees(rotation.getZ());
                this.axis = "z";
            } else {
                this.angle = (float)Math.toDegrees(rotation.getY());
                this.axis = "y";
            }
            this.angle = (float)((int)(this.angle * 10.0f)) / 10.0f;
            if (Math.abs(this.angle) > 45.0f || (double)this.angle % 22.5 != 0.0) {
                warnBadAngle.setAngle(this.angle);
                warnBadAngle.log();
            }
            this.angle = (float)((int)((double)TMath.clamp(this.angle, -45.0f, 45.0f) / 22.5)) * 22.5f;
        }

        private void setOrigin(Vector origin) {
            this.origin[0] = (float)origin.getX();
            this.origin[1] = (float)origin.getY();
            this.origin[2] = (float)origin.getZ();
        }

        private void shrink(double ratio) {
            this.origin[0] = (float)((double)this.origin[0] * ratio);
            this.origin[1] = (float)((double)this.origin[1] * ratio);
            this.origin[2] = (float)((double)this.origin[2] * ratio);
        }

        private void offset(float x, float y, float z) {
            this.origin[0] = this.origin[0] + x;
            this.origin[1] = this.origin[1] + y;
            this.origin[2] = this.origin[2] + z;
        }

        public float getAngle() {
            return this.angle;
        }

        public String getAxis() {
            return this.axis;
        }

        public float[] getOrigin() {
            return this.origin;
        }

        public void setAngle(float angle) {
            this.angle = angle;
        }

        public void setAxis(String axis) {
            this.axis = axis;
        }
    }

    static class JavaFace {
        private final float[] uv = new float[4];
        private int rotation;
        private String texture;
        private final int tintindex = 0;

        protected JavaFace(BlockbenchFace face) {
            this.setUV(face.getX1(), face.getY1(), face.getX2(), face.getY2());
            this.rotation = face.getRotation();
            this.texture = face.getTexture() != null ? "#" + face.getTexture() : "#missing";
        }

        private void setUV(double x1, double y1, double x2, double y2) {
            this.uv[0] = (float)x1;
            this.uv[1] = (float)y1;
            this.uv[2] = (float)x2;
            this.uv[3] = (float)y2;
        }

        public float[] getUv() {
            return this.uv;
        }

        public int getRotation() {
            return this.rotation;
        }

        public String getTexture() {
            return this.texture;
        }

        public int getTintindex() {
            return this.tintindex;
        }

        public void setRotation(int rotation) {
            this.rotation = rotation;
        }

        public void setTexture(String texture) {
            this.texture = texture;
        }
    }
}

