/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class BaseItem {
    private final transient AtomicInteger data = new AtomicInteger();
    private transient String name;
    private String parent;
    private Map<String, String> textures;
    private final List<JavaOverride> overrides = Lists.newArrayList();

    public void resetData() {
        this.data.set(0);
        this.overrides.clear();
    }

    public void addModel(String model) {
        this.overrides.add(new JavaOverride(model, this.data.incrementAndGet()));
    }

    public int getData() {
        return this.data.get();
    }

    public void offsetData(int offset) {
        this.data.set(offset);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static class JavaOverride {
        private final Map<String, Integer> predicate = Maps.newConcurrentMap();
        private final String model;

        public JavaOverride(String model, int id) {
            this.model = model;
            this.predicate.put("custom_model_data", id);
        }

        public Map<String, Integer> getPredicate() {
            return this.predicate;
        }

        public String getModel() {
            return this.model;
        }
    }
}

