/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator;

import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.parser.ModelParser;
import com.ticxo.modelengine.api.model.mananger.ModelRegistry;
import com.ticxo.modelengine.api.utils.TFile;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.generator.java.BaseItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ModelGeneratorImpl
implements ModelGenerator {
    private final Set<ModelParser> parsers = Sets.newConcurrentHashSet();
    private final File blueprintFolder;
    private final File packFolder;
    private final File baseItemFolder;
    private final File zippedResourcePack;
    private final ModelRegistry registry;
    private boolean initialized;
    private final Map<ModelRegistrationEvent.Phase, Set<Runnable>> tasks = Maps.newConcurrentMap();
    private File modelFolder;
    private File textureFolder;
    private String namespace;
    private BaseItemEnum baseItemType;
    private BaseItem baseItem;

    public ModelGeneratorImpl() {
        this.blueprintFolder = TFile.createDirectory(ModelEngineAPI.api.getDataFolder(), "blueprints");
        this.packFolder = TFile.createDirectory(ModelEngineAPI.api.getDataFolder(), "resource pack");
        this.baseItemFolder = TFile.createDirectory(this.packFolder, "assets", "minecraft", "models", "item");
        this.zippedResourcePack = TFile.createFile(ModelEngineAPI.api.getDataFolder(), "resource pack.zip");
        this.registry = ModelEngineAPI.api.getModelRegistry();
        ModelEngineAPI.getConfigManager().registerReferenceUpdate(this::updateConfigs);
    }

    public void updateConfigs() {
        this.changeNamespace(ConfigProperty.NAMESPACE.getString());
        this.changeBaseItem(ConfigProperty.ITEM_MODEL.getBaseItem());
    }

    @Override
    public void queueTask(ModelRegistrationEvent.Phase phase, Runnable runnable) {
        Set set = this.tasks.get((Object)phase);
        if (set == null) {
            set = Sets.newConcurrentHashSet();
            this.tasks.put(phase, set);
        }
        set.add(runnable);
    }

    private void executeQueuedTask(ModelRegistrationEvent.Phase phase) {
        Set<Runnable> set = this.tasks.get((Object)phase);
        if (set == null) {
            return;
        }
        set.forEach(Runnable::run);
        set.clear();
    }

    @Override
    public void registerModelParser(ModelParser parser) {
        this.parsers.add(parser);
    }

    @Override
    public void changeNamespace(String namespace) {
        this.namespace = namespace;
        this.modelFolder = TFile.createDirectory(this.packFolder, "assets", namespace, "models");
        this.textureFolder = TFile.createDirectory(this.packFolder, "assets", namespace, "textures", "entity");
    }

    @Override
    public void changeBaseItem(BaseItemEnum base) {
        this.baseItemType = base;
        String name = base.name().toLowerCase(Locale.ENGLISH);
        InputStream inputStream = ModelEngineAPI.api.getResource("pack/colorable/" + name + ".json");
        if (inputStream == null) {
            TLogger.warn("Unknown colorable item: " + name + ". Reverting to use leather_horse_armor.");
            inputStream = ModelEngineAPI.api.getResource("pack/colorable/leather_horse_armor.json");
        }
        if (inputStream == null) {
            TLogger.error("Unable to locate base files.");
            return;
        }
        InputStreamReader itemTemplateReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.baseItem = (BaseItem)ModelEngineAPI.gson.fromJson((Reader)itemTemplateReader, BaseItem.class);
        this.baseItem.setName(name);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void importModels() {
        this.initialized = false;
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.PRE));
        this.executeQueuedTask(ModelRegistrationEvent.Phase.PRE);
        this.registry.clearRegistry();
        if (!this.blueprintFolder.isDirectory()) {
            return;
        }
        fa = this.blueprintFolder.listFiles();
        if (fa == null || fa.length == 0) {
            return;
        }
        files = Arrays.asList(fa);
        compartment = new LinkedList<File>();
        files.sort((Comparator<File>)Ordering.natural());
        totalOffset = -1;
        this.baseItem.resetData();
        i = 0;
        block4: while (true) lbl-1000:
        // 6 sources

        {
            for (File file : files) {
                if (!file.isFile()) {
                    if (!file.isDirectory()) continue;
                    compartment.add(file);
                    continue;
                }
                fileParsed = false;
                TLogger.log();
                TLogger.log(LogColor.CYAN + "Generating " + file.getName() + ".");
                for (ModelParser parser : this.parsers) {
                    if (!parser.validateFile(file)) continue;
                    try {
                        blueprint = parser.generate(file);
                        if (blueprint == null) continue;
                        blueprint.constructFlatBoneMap();
                        this.registry.registerBlueprint(blueprint);
                        fileParsed = true;
                        if (++i <= 5) break;
                        break block4;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (fileParsed) continue;
                IError.UNKNOWN_FORMAT.log();
            }
            while (!compartment.isEmpty()) {
                ca = ((File)compartment.poll()).listFiles();
                this.baseItem.offsetData(totalOffset += ConfigProperty.COMPARTMENT_SIZE.getInt());
                if (ca == null || ca.length == 0) continue;
                files = Arrays.asList(ca);
                files.sort((Comparator<File>)Ordering.natural());
                continue block4;
                ** continue;
            }
            break;
        }
        baseItemFile = TFile.createFile(this.baseItemFolder, new String[]{this.baseItem.getName() + ".json"});
        try {
            writer = new FileWriter(baseItemFile);
            writer.write(ModelEngineAPI.gson.toJson((Object)this.baseItem));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initialized = true;
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.POST));
        this.executeQueuedTask(ModelRegistrationEvent.Phase.POST);
        TFile.copyResource(TFile.createFile(this.packFolder, new String[]{"pack.png"}), "pack/pack.png");
        TFile.copyResource(TFile.createFile(this.packFolder, new String[]{"pack.mcmeta"}), "pack/pack.mcmeta");
        if (ConfigProperty.ZIP.getBoolean()) {
            this.zipResourcePack();
        }
        ModelEngineAPI.callEvent(new ModelRegistrationEvent(ModelRegistrationEvent.Phase.FINAL));
        this.executeQueuedTask(ModelRegistrationEvent.Phase.FINAL);
    }

    @Override
    public void importModelsAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ModelEngineAPI.api, this::importModels);
    }

    @Override
    public void zipResourcePack() {
        try {
            FileOutputStream zippedFOS = new FileOutputStream(this.zippedResourcePack);
            ZipOutputStream zipOut = new ZipOutputStream(zippedFOS);
            File[] files = this.packFolder.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                this.zipFile(file, file.getName(), zipOut);
            }
            zipOut.close();
            zippedFOS.close();
            TLogger.log();
            TLogger.log(LogColor.BRIGHT_GREEN + "Resource pack zipped.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
            }
            zipOut.closeEntry();
            File[] children = fileToZip.listFiles();
            if (children != null) {
                for (File childFile : children) {
                    this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public Set<ModelParser> getParsers() {
        return this.parsers;
    }

    public File getBlueprintFolder() {
        return this.blueprintFolder;
    }

    public File getPackFolder() {
        return this.packFolder;
    }

    public File getBaseItemFolder() {
        return this.baseItemFolder;
    }

    public File getZippedResourcePack() {
        return this.zippedResourcePack;
    }

    public ModelRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public Map<ModelRegistrationEvent.Phase, Set<Runnable>> getTasks() {
        return this.tasks;
    }

    public File getModelFolder() {
        return this.modelFolder;
    }

    public File getTextureFolder() {
        return this.textureFolder;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public BaseItemEnum getBaseItemType() {
        return this.baseItemType;
    }

    public BaseItem getBaseItem() {
        return this.baseItem;
    }
}

