/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UndisguiseCommand
extends AbstractCommand {
    public UndisguiseCommand(AbstractCommand parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        Player player = (Player)sender;
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            return true;
        }
        if (args.length == 0) {
            modeledEntity.setBaseEntityVisible(true);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
            ModelEngineAPI.removeModeledEntity(player.getUniqueId());
        } else {
            for (String modelId : args) {
                ActiveModel model = modeledEntity.removeModel(modelId);
                if (model == null) continue;
                model.destroy();
            }
            if (modeledEntity.getModels().isEmpty()) {
                modeledEntity.setBaseEntityVisible(true);
                ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
                ModelEngineAPI.removeModeledEntity(player.getUniqueId());
            }
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        Player player = (Player)sender;
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            return list;
        }
        if (args.length > 0) {
            String arg = args[args.length - 1];
            MECommand.getModelIdTabComplete(list, arg, modeledEntity);
        }
        return list;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.undisguise";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "undisguise";
    }
}

