/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SummonCommand
extends AbstractCommand {
    public SummonCommand(AbstractCommand parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length < 1) {
            return false;
        }
        EntityType type = EntityType.PIG;
        if (args.length >= 2) {
            try {
                type = EntityType.valueOf((String)args[1].toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Player player = (Player)sender;
        Location location = player.getLocation();
        Entity entity = player.getWorld().spawnEntity(location, type);
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(args[0]);
        if (blueprint == null) {
            return false;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity(entity);
        modeledEntity.setBaseEntityVisible(false);
        ActiveModel activeModel = ModelEngineAPI.createActiveModel(blueprint);
        modeledEntity.addModel(activeModel, true);
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                MECommand.getModelIdTabComplete(list, args[0]);
                break;
            }
            case 2: {
                String arg = args[1];
                for (EntityType type : EntityType.values()) {
                    String name = type.name();
                    if (!name.startsWith(arg.toUpperCase(Locale.ENGLISH))) continue;
                    list.add(name);
                }
                break;
            }
        }
        return list;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.summon";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "summon";
    }
}

