/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.AnimationProperty;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.command.MECommand;
import com.ticxo.modelengine.command.sub.SelectCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StateCommand
extends AbstractCommand {
    public StateCommand(AbstractCommand parent) {
        super(parent);
        this.addSubCommands(new AddStateCommand(this));
        this.addSubCommands(new RemoveStateCommand(this));
        this.addSubCommands(new ListStateCommand(this));
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.state";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "state";
    }

    static class AddStateCommand
    extends AbstractCommand {
        public AddStateCommand(AbstractCommand parent) {
            super(parent);
        }

        @Override
        public boolean onCommand(CommandSender sender, String[] args) {
            if (args.length < 2) {
                return false;
            }
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return false;
            }
            ActiveModel model = entity.getModel(args[0]);
            if (model == null) {
                return false;
            }
            if (!model.getBlueprint().getAnimations().containsKey(args[1])) {
                return false;
            }
            AnimationHandler handler = model.getAnimationHandler();
            handler.playAnimation(args[1], 0.0, 0.0, 1.0, true);
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            switch (args.length) {
                case 1: {
                    MECommand.getModelIdTabComplete(list, args[0], entity);
                    break;
                }
                case 2: {
                    ActiveModel model = entity.getModel(args[0]);
                    if (model == null) {
                        return list;
                    }
                    MECommand.getStateTabComplete(list, args[1], model.getBlueprint());
                }
            }
            return list;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.add";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "add";
        }
    }

    static class RemoveStateCommand
    extends AbstractCommand {
        public RemoveStateCommand(AbstractCommand parent) {
            super(parent);
        }

        @Override
        public boolean onCommand(CommandSender sender, String[] args) {
            if (args.length < 2) {
                return false;
            }
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return false;
            }
            ActiveModel model = entity.getModel(args[0]);
            if (model == null) {
                return false;
            }
            AnimationHandler handler = model.getAnimationHandler();
            handler.stopAnimation(args[1]);
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            switch (args.length) {
                case 1: {
                    MECommand.getModelIdTabComplete(list, args[0], entity);
                    break;
                }
                case 2: {
                    ActiveModel model = entity.getModel(args[0]);
                    if (model == null) {
                        return list;
                    }
                    MECommand.getStateTabComplete(list, args[1], model);
                }
            }
            return list;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.remove";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "remove";
        }
    }

    static class ListStateCommand
    extends AbstractCommand {
        public ListStateCommand(AbstractCommand parent) {
            super(parent);
        }

        @Override
        public boolean onCommand(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return false;
            }
            StringBuilder builder = new StringBuilder();
            switch (args.length) {
                case 0: {
                    for (String modelId : entity.getModels().keySet()) {
                        ActiveModel model = entity.getModel(modelId);
                        builder.append(modelId).append(": ");
                        for (AnimationProperty animation : model.getAnimationHandler().getAnimations()) {
                            builder.append(animation.getBlueprintAnimation().getName()).append(", ");
                        }
                        builder.delete(builder.length() - 2, builder.length()).append("\n");
                    }
                    break;
                }
                case 1: {
                    ActiveModel model = entity.getModel(args[0]);
                    if (model == null) {
                        return false;
                    }
                    builder.append(args[0]).append(": ");
                    for (AnimationProperty animation : model.getAnimationHandler().getAnimations()) {
                        builder.append(animation.getBlueprintAnimation().getName()).append(", ");
                    }
                    builder.delete(builder.length() - 2, builder.length());
                }
            }
            player.sendMessage(builder.toString());
            return true;
        }

        @Override
        public List<String> onTabComplete(CommandSender sender, String[] args) {
            Player player = (Player)sender;
            ModeledEntity entity = SelectCommand.SELECTED.get(player);
            if (entity == null) {
                return null;
            }
            ArrayList<String> list = new ArrayList<String>();
            if (args.length == 1) {
                MECommand.getModelIdTabComplete(list, args[0], entity);
            }
            return list;
        }

        @Override
        public String getPermissionNode() {
            return "modelengine.command.state.list";
        }

        @Override
        public boolean isConsoleFriendly() {
            return true;
        }

        @Override
        public String getName() {
            return "list";
        }
    }
}

