/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.model.ModeledEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class SelectCommand
extends AbstractCommand {
    public static final Map<CommandSender, ModeledEntity> SELECTED = Maps.newConcurrentMap();

    public SelectCommand(AbstractCommand parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        ModeledEntity modeledEntity = null;
        if (args.length >= 1) {
            modeledEntity = ModelEngineAPI.getModelTicker().getModeledEntity(UUID.fromString(args[0]));
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            modeledEntity = SelectCommand.getTargetedModeledEntity(player);
        }
        if (modeledEntity == null) {
            SELECTED.remove(sender);
        } else {
            SELECTED.put(sender, modeledEntity);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> tabs = new ArrayList<String>();
        for (UUID uuid : ModelEngineAPI.getModelTicker().getAllModeledEntityUUID()) {
            tabs.add(uuid.toString());
        }
        return tabs;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.select";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String[] getAliases() {
        return new String[]{"sel"};
    }

    @Override
    public String getName() {
        return "select";
    }

    @Nullable
    private static ModeledEntity getTargetedModeledEntity(Player player) {
        Location eye = player.getEyeLocation();
        RayTraceResult result = player.getWorld().rayTraceEntities(eye, eye.getDirection(), 32.0, entity -> ModelEngineAPI.isModeledEntity(entity.getUniqueId()));
        if (result == null) {
            return null;
        }
        Entity entity2 = result.getHitEntity();
        if (entity2 == null) {
            return null;
        }
        return ModelEngineAPI.getModeledEntity(entity2.getUniqueId());
    }
}

