/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.events.ModelRegistrationEvent;
import java.util.List;
import org.bukkit.command.CommandSender;

public class ReloadCommand
extends AbstractCommand {
    public ReloadCommand(AbstractCommand parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length == 0) {
            this.reloadConfig(sender);
            this.reloadModels(sender);
            return true;
        }
        switch (args[0]) {
            case "models": {
                this.reloadModels(sender);
                break;
            }
            case "config": {
                this.reloadConfig(sender);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void reloadConfig(CommandSender sender) {
        ModelEngineAPI.getConfigManager().reload();
        ModelEngineAPI.getConfigManager().updateReferences();
        sender.sendMessage("Config reloaded.");
    }

    private void reloadModels(CommandSender sender) {
        ModelEngineAPI.api.getGenerator().importModelsAsync();
        ModelEngineAPI.api.getGenerator().queueTask(ModelRegistrationEvent.Phase.POST, () -> sender.sendMessage("Model reloaded."));
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        return List.of("models", "config");
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.reload";
    }

    @Override
    public boolean isConsoleFriendly() {
        return true;
    }

    @Override
    public String getName() {
        return "reload";
    }
}

