/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.command.sub;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.command.MECommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DisguiseCommand
extends AbstractCommand {
    public DisguiseCommand(AbstractCommand parent) {
        super(parent);
    }

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        RangeManager rangeManager;
        Player player = (Player)sender;
        if (args.length < 1) {
            return false;
        }
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(args[0]);
        if (blueprint == null) {
            return false;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(player);
            modeledEntity.setBaseEntityVisible(false);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, true);
        }
        if ((rangeManager = modeledEntity.getRangeManager()) instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguise = (RangeManager.Disguise)((Object)rangeManager);
            disguise.setIncludeSelf(args.length < 2 || Boolean.parseBoolean(args[1]));
        }
        if (modeledEntity.getModel(args[0]) == null) {
            ActiveModel activeModel = ModelEngineAPI.createActiveModel(blueprint);
            modeledEntity.addModel(activeModel, false);
        }
        return true;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args.length) {
            case 1: {
                MECommand.getModelIdTabComplete(list, args[0]);
                break;
            }
            case 2: {
                String arg = args[1].toLowerCase(Locale.ENGLISH);
                if ("true".startsWith(arg)) {
                    list.add("true");
                }
                if (!"false".startsWith(arg)) break;
                list.add("false");
            }
        }
        return list;
    }

    @Override
    public String getPermissionNode() {
        return "modelengine.command.disguise";
    }

    @Override
    public boolean isConsoleFriendly() {
        return false;
    }

    @Override
    public String getName() {
        return "disguise";
    }
}

