/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.citizens;

import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.BukkitEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class CitizensEntity
implements BaseEntity<NPC> {
    private final NPC original;
    private final BukkitEntity wrapped;

    public CitizensEntity(@NotNull NPC npc) {
        this(npc, new BukkitEntity(npc.getEntity()));
    }

    public CitizensEntity(@NotNull NPC npc, @NotNull BukkitEntity wrapped) {
        this.original = npc;
        this.wrapped = wrapped;
    }

    @Override
    public MoveController wrapMoveControl() {
        return this.wrapped.wrapMoveControl();
    }

    @Override
    public LookController wrapLookControl() {
        return this.wrapped.wrapLookControl();
    }

    @Override
    public BodyRotationController wrapBodyRotationControl() {
        return this.wrapped.wrapBodyRotationControl();
    }

    @Override
    public void wrapNavigation() {
        this.wrapped.wrapNavigation();
    }

    @Override
    public RangeManager wrapRangeManager(IModel model) {
        return this.wrapped.wrapRangeManager(model);
    }

    @Override
    public boolean onHurt(IDamageSource damageSource, float damage) {
        return this.wrapped.onHurt(damageSource, damage);
    }

    @Override
    public void onInteract(Player player, EquipmentSlot hand) {
        this.wrapped.onInteract(player, hand);
    }

    @Override
    public void setHitbox(Hitbox hitbox) {
        this.wrapped.setHitbox(hitbox);
    }

    @Override
    public void setStepHeight(double height) {
        this.wrapped.setStepHeight(height);
    }

    @Override
    public void setCollidableToLiving(LivingEntity living, boolean flag) {
        this.wrapped.setCollidableToLiving(living, flag);
    }

    @Override
    public void broadcastSpawnPacket() {
        this.wrapped.broadcastSpawnPacket();
    }

    @Override
    public void broadcastDespawnPacket() {
        this.wrapped.broadcastDespawnPacket();
    }

    @Override
    public int getEntityId() {
        return this.wrapped.getEntityId();
    }

    @Override
    public UUID getUniqueId() {
        return this.wrapped.getUniqueId();
    }

    @Override
    public Location getLocation() {
        return this.wrapped.getLocation();
    }

    @Override
    public World getWorld() {
        return this.wrapped.getWorld();
    }

    @Override
    public boolean isDead() {
        return !this.original.isSpawned() || this.wrapped.isDead();
    }

    @Override
    public boolean isGlowing() {
        return this.wrapped.isGlowing();
    }

    @Override
    public boolean isOnGround() {
        return this.wrapped.isOnGround();
    }

    @Override
    public boolean isMoving() {
        return this.wrapped.isMoving();
    }

    @Override
    public void setYHeadRot(float rot) {
        this.wrapped.setYHeadRot(rot);
    }

    @Override
    public float getYHeadRot() {
        return this.wrapped.getYHeadRot();
    }

    @Override
    public float getXHeadRot() {
        return this.wrapped.getXHeadRot();
    }

    @Override
    public void setYBodyRot(float rot) {
        this.wrapped.setYBodyRot(rot);
    }

    @Override
    public float getYBodyRot() {
        return this.wrapped.getYBodyRot();
    }

    @Override
    public List<Entity> getPassengers() {
        return this.wrapped.getPassengers();
    }

    @Override
    public RangeManager getRangeManager() {
        return this.wrapped.getRangeManager();
    }

    @Override
    public Double getStepHeight() {
        return this.wrapped.getStepHeight();
    }

    @Override
    public Hitbox getHitbox() {
        return this.wrapped.getHitbox();
    }

    @Override
    public ModelHitbox getModelHitbox() {
        return this.wrapped.getModelHitbox();
    }

    @Override
    public NPC getOriginal() {
        return this.original;
    }

    public BukkitEntity getWrapped() {
        return this.wrapped;
    }
}

