/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class TMath {
    public static final double TAU = Math.PI * 2;
    public static final double PI_2 = 1.5707963267948966;
    public static final double PI_4 = 0.7853981633974483;
    public static final double EPSILON = 1.0E-5;
    protected static SlerpMode slerpMode = SlerpMode.SLERP;
    protected static double movementResolution = 0.001;

    public static void updateConfigs() {
        slerpMode = ConfigProperty.SLERP_MODE.getSlerpMode();
        movementResolution = ConfigProperty.MOVE_RESOLUTION.getDouble();
    }

    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float clamp(float value, float min, float max) {
        return Math.min(Math.max(value, min), max);
    }

    public static double tryParse(String val, double def) {
        if (val == null) {
            return def;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException ignored) {
            return def;
        }
    }

    public static boolean isBoundingBoxWithinDistance(@NotNull Vector start, @NotNull Vector direction, BoundingBox boundingBox, double maxDistance) {
        double tzMax;
        double tzMin;
        double tyMax;
        double tyMin;
        double tMax;
        double tMin;
        double startX = start.getX();
        double startY = start.getY();
        double startZ = start.getZ();
        Vector dir = direction.clone();
        if (dir.getX() == 0.0) {
            dir.setX(0);
        }
        if (dir.getY() == 0.0) {
            dir.setY(0);
        }
        if (dir.getZ() == 0.0) {
            dir.setZ(0);
        }
        dir.normalize();
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        double divX = 1.0 / dirX;
        double divY = 1.0 / dirY;
        double divZ = 1.0 / dirZ;
        if (dirX >= 0.0) {
            tMin = (boundingBox.getMinX() - startX) * divX;
            tMax = (boundingBox.getMaxX() - startX) * divX;
        } else {
            tMin = (boundingBox.getMaxX() - startX) * divX;
            tMax = (boundingBox.getMinX() - startX) * divX;
        }
        if (dirY >= 0.0) {
            tyMin = (boundingBox.getMinY() - startY) * divY;
            tyMax = (boundingBox.getMaxY() - startY) * divY;
        } else {
            tyMin = (boundingBox.getMaxY() - startY) * divY;
            tyMax = (boundingBox.getMinY() - startY) * divY;
        }
        if (tMin > tyMax || tMax < tyMin) {
            return false;
        }
        if (tyMin > tMin) {
            tMin = tyMin;
        }
        if (tyMax < tMax) {
            tMax = tyMax;
        }
        if (dirZ >= 0.0) {
            tzMin = (boundingBox.getMinZ() - startZ) * divZ;
            tzMax = (boundingBox.getMaxZ() - startZ) * divZ;
        } else {
            tzMin = (boundingBox.getMaxZ() - startZ) * divZ;
            tzMax = (boundingBox.getMinZ() - startZ) * divZ;
        }
        if (tMin > tzMax || tMax < tzMin) {
            return false;
        }
        if (tzMin > tMin) {
            tMin = tzMin;
        }
        if (tzMax < tMax) {
            tMax = tzMax;
        }
        if (tMax < 0.0) {
            return false;
        }
        return !(tMin > maxDistance);
    }

    public static boolean isSimilar(Vector a, Vector b) {
        return Math.abs(b.getX() - a.getX()) < movementResolution && Math.abs(b.getY() - a.getY()) < movementResolution && Math.abs(b.getZ() - a.getZ()) < movementResolution;
    }

    public static EulerAngle makeAngle(double x, double y, double z) {
        return new EulerAngle(Math.toRadians(x), Math.toRadians(y), Math.toRadians(z));
    }

    public static EulerAngle add(EulerAngle a, EulerAngle b) {
        return a.add(b.getX(), b.getY(), b.getZ());
    }

    public static EulerAngle globalRotate(EulerAngle origin, EulerAngle delta) {
        return Quaternion.globalRotate(Quaternion.fromEulerAngle(origin), Quaternion.fromEulerAngle(delta)).toEulerAngle();
    }

    public static EulerAngle localRotate(EulerAngle origin, EulerAngle delta) {
        return TMath.globalRotate(delta, origin);
    }

    public static float wrapRadian(float r) {
        if ((double)(r = (float)((double)r % (Math.PI * 2))) < -Math.PI) {
            r = (float)((double)r + Math.PI * 2);
        }
        if ((double)r > Math.PI) {
            r = (float)((double)r - Math.PI * 2);
        }
        return r;
    }

    public static float wrapDegree(float r) {
        if ((r %= 360.0f) < -180.0f) {
            r += 360.0f;
        }
        if (r > 180.0f) {
            r -= 360.0f;
        }
        return r;
    }

    public static float radianDifference(float a, float b) {
        return TMath.wrapRadian(b - a);
    }

    public static float degreeDifference(float a, float b) {
        return TMath.wrapDegree(b - a);
    }

    public static float rotateIfNecessary(float current, float target, float negativeClamp, float positiveClamp) {
        float delta = TMath.degreeDifference(current, target);
        float clampedDelta = TMath.clamp(delta, negativeClamp, positiveClamp);
        return target - clampedDelta;
    }

    public static byte rotToByte(float rot) {
        return (byte)(rot * 256.0f / 360.0f);
    }

    public static float byteToRot(byte rot) {
        return (float)rot / 256.0f * 360.0f;
    }

    public static double lerp(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    public static double lerp(double a, double b, double aT, double bT) {
        return aT * a + bT * b;
    }

    public static double rotLerp(double a, double b, double t) {
        return a + (double)TMath.degreeDifference((float)a, (float)b) * t;
    }

    public static float rotLerp(float a, float b, double t) {
        return (float)((double)a + (double)TMath.degreeDifference(a, b) * t);
    }

    public static double smoothLerp(double a, double b, double c, double d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        double a1 = TMath.lerp(a, b, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        double a2 = TMath.lerp(b, c, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        double a3 = TMath.lerp(c, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        double b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        double b2 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static Vector lerp(Vector a, Vector b, double t) {
        return new Vector(TMath.lerp(a.getX(), b.getX(), t), TMath.lerp(a.getY(), b.getY(), t), TMath.lerp(a.getZ(), b.getZ(), t));
    }

    public static Vector lerp(Vector a, Vector b, double aT, double bT) {
        return new Vector(TMath.lerp(a.getX(), b.getX(), aT, bT), TMath.lerp(a.getY(), b.getY(), aT, bT), TMath.lerp(a.getZ(), b.getZ(), aT, bT));
    }

    public static Vector smoothLerp(Vector a, Vector b, Vector c, Vector d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        Vector a1 = TMath.lerp(a, b, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Vector a2 = TMath.lerp(b, c, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Vector a3 = TMath.lerp(c, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Vector b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Vector b2 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static EulerAngle lerp(EulerAngle a, EulerAngle b, double t) {
        return new EulerAngle(TMath.lerp(a.getX(), b.getX(), t), TMath.lerp(a.getY(), b.getY(), t), TMath.lerp(a.getZ(), b.getZ(), t));
    }

    public static EulerAngle lerp(EulerAngle a, EulerAngle b, double aT, double bT) {
        return new EulerAngle(TMath.lerp(a.getX(), b.getX(), aT, bT), TMath.lerp(a.getY(), b.getY(), aT, bT), TMath.lerp(a.getZ(), b.getZ(), aT, bT));
    }

    public static EulerAngle smoothLerp(EulerAngle a, EulerAngle b, EulerAngle c, EulerAngle d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        EulerAngle a1 = TMath.lerp(a, b, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        EulerAngle a2 = TMath.lerp(b, c, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        EulerAngle a3 = TMath.lerp(c, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        EulerAngle b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        EulerAngle b2 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static EulerAngle slerp(EulerAngle a, EulerAngle b, double t) {
        return TMath.slerp(Quaternion.fromEulerAngle(a), Quaternion.fromEulerAngle(b), t).toEulerAngle();
    }

    public static Quaternion lerp(Quaternion a, Quaternion b, double aT, double bT) {
        return new Quaternion(TMath.lerp(a.getX(), b.getX(), aT, bT), TMath.lerp(a.getY(), b.getY(), aT, bT), TMath.lerp(a.getZ(), b.getZ(), aT, bT), TMath.lerp(a.getW(), b.getW(), aT, bT)).normalize();
    }

    public static Quaternion onlerp(Quaternion a, Quaternion b, double t) {
        float ca = (float)a.dot(b);
        t = TMath.aprox(ca, (float)t);
        return TMath.lerp(a, b, 1.0 - t, ca > 0.0f ? t : -t);
    }

    public static Quaternion smoothOnlerp(Quaternion a, Quaternion b, Quaternion c, Quaternion d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        float ca = (float)b.dot(c);
        t = TMath.aprox(ca, (float)((t2 - t1) * t + t1));
        Quaternion a1 = TMath.lerp(a, b, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Quaternion a2 = TMath.lerp(b, c, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Quaternion a3 = TMath.lerp(c, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Quaternion b1 = TMath.lerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Quaternion b2 = TMath.lerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    private static float aprox(float ca, float r) {
        float diff = Math.abs(ca);
        float a = 1.0904f + diff * (-3.2452f + diff * (3.55645f - diff * 1.43519f));
        float b = 0.848013f + diff * (-1.06021f + diff * 0.215638f);
        float k = a * (r - 0.5f) * (r - 0.5f) + b;
        return r + r * (r - 0.5f) * (r - 1.0f) * k;
    }

    public static Quaternion tSlerp(Quaternion a, Quaternion b, double t) {
        return TMath.tSlerp(a, b, 1.0 - t, t);
    }

    public static Quaternion tSlerp(Quaternion a, Quaternion b, double aT, double bT) {
        double diff = a.dot(b);
        double absDiff = Math.abs(diff);
        if (absDiff <= 0.9995) {
            double theta = Math.acos(absDiff);
            double sinTheta = Math.sin(theta);
            aT = Math.sin(theta * aT) / sinTheta;
            bT = Math.sin(theta * bT) / sinTheta;
            if (diff < 0.0) {
                aT *= -1.0;
            }
        }
        return a.altMul(aT).add(b.altMul(bT)).normalize();
    }

    public static Quaternion smoothTSlerp(Quaternion a, Quaternion b, Quaternion c, Quaternion d, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        Quaternion a1 = TMath.tSlerp(a, b, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Quaternion a2 = TMath.tSlerp(b, c, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Quaternion a3 = TMath.tSlerp(c, d, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Quaternion b1 = TMath.tSlerp(a1, a2, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Quaternion b2 = TMath.tSlerp(a2, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.tSlerp(b1, b2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static Quaternion slerp(Quaternion a, Quaternion b, double t) {
        return switch (slerpMode) {
            default -> throw new IncompatibleClassChangeError();
            case SlerpMode.SLERP -> TMath.tSlerp(a, b, t);
            case SlerpMode.ONLERP -> TMath.onlerp(a, b, t);
        };
    }

    public static EulerAngle smoothSlerp(EulerAngle a, EulerAngle b, EulerAngle c, EulerAngle d, double t) {
        return switch (slerpMode) {
            default -> throw new IncompatibleClassChangeError();
            case SlerpMode.SLERP -> TMath.smoothTSlerp(Quaternion.fromEulerAngle(a), Quaternion.fromEulerAngle(b), Quaternion.fromEulerAngle(c), Quaternion.fromEulerAngle(d), t).toEulerAngle();
            case SlerpMode.ONLERP -> TMath.smoothOnlerp(Quaternion.fromEulerAngle(a), Quaternion.fromEulerAngle(b), Quaternion.fromEulerAngle(c), Quaternion.fromEulerAngle(d), t).toEulerAngle();
        };
    }

    public static String toString(EulerAngle angle) {
        return String.format("[%s, %s, %s]", Math.toDegrees(angle.getX()), Math.toDegrees(angle.getY()), Math.toDegrees(angle.getZ()));
    }

    public static float fastSqrt(float value) {
        return value * TMath.fastInvSqrt(value);
    }

    public static double fastSqrt(double value) {
        return value * TMath.fastInvSqrt(value);
    }

    public static float fastInvSqrt(float value) {
        float half = 0.5f * value;
        int rawBits = Float.floatToIntBits(value);
        rawBits = 1597463007 - (rawBits >> 1);
        value = Float.intBitsToFloat(rawBits);
        value = (float)((double)value * (1.5 - (double)(half * value * value)));
        return value;
    }

    public static double fastInvSqrt(double value) {
        double half = 0.5 * value;
        long rawBits = Double.doubleToRawLongBits(value);
        rawBits = 6910469410427058090L - (rawBits >> 1);
        value = Double.longBitsToDouble(rawBits);
        value *= 1.5 - half * value * value;
        return value;
    }

    public static double fastAsin(double val) {
        return TMath.fastAtan(val * TMath.fastInvSqrt(1.0 - val * val));
    }

    public static double fastAtan(double val) {
        if (val < -1.0 || val > 1.0) {
            return Math.atan(val);
        }
        return TMath.atanScalarAprox(val);
    }

    public static double fastAtan2(double y, double x) {
        boolean isNegX;
        boolean isNegY;
        double var4 = y * y + x * x;
        if (Double.isNaN(var4)) {
            return Double.NaN;
        }
        if (x == 0.0) {
            return y == 0.0 ? Double.NaN : (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
        }
        boolean bl = isNegY = y < 0.0;
        if (isNegY) {
            y = -y;
        }
        boolean bl2 = isNegX = x < 0.0;
        if (isNegX) {
            x = -x;
        }
        boolean swap = y > x;
        double res = TMath.atanScalarAprox(swap ? x / y : y / x);
        if (swap) {
            res = 1.5707963267948966 - res;
        }
        if (isNegX) {
            res = Math.PI - res;
        }
        if (isNegY) {
            res = -res;
        }
        return res;
    }

    private static double atanScalarAprox(double x) {
        double a = 0.99997726;
        double b = -0.33262347;
        double c = 0.19354346;
        double d = -0.11643287;
        double e = 0.05265332;
        double f = -0.0117212;
        double z = x * x;
        return x * (a + z * (b + z * (c + z * (d + z * (e + z * f)))));
    }

    public static double fastLength(double x, double y, double z) {
        double lSqr = x * x + y * y + z * z;
        return lSqr * TMath.fastInvSqrt(lSqr);
    }

    public static Vector fastNormalize(Vector vector) {
        return vector.multiply(TMath.fastInvSqrt(vector.lengthSquared()));
    }

    public static int biasRound(double val, double res) {
        return (int)(val % 1.0 < res ? Math.floor(val) : Math.ceil(val));
    }

    public static enum SlerpMode {
        SLERP,
        ONLERP;


        public static SlerpMode get(String name) {
            try {
                return SlerpMode.valueOf(name);
            }
            catch (IllegalArgumentException ignored) {
                return SLERP;
            }
        }
    }
}

