/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.util.EulerAngle;

public class Quaternion {
    private double x;
    private double y;
    private double z;
    private double w;

    public Quaternion(Quaternion copy) {
        this(copy.x, copy.y, copy.z, copy.w);
    }

    public static Quaternion fromEulerAngle(EulerAngle eulerAngle) {
        return Quaternion.fromEulerAngle(eulerAngle.getX(), eulerAngle.getY(), eulerAngle.getZ());
    }

    public static Quaternion fromEulerAngleDegree(double x, double y, double z) {
        return Quaternion.fromEulerAngle(Math.toRadians(x), Math.toRadians(y), Math.toRadians(z));
    }

    public static Quaternion fromEulerAngle(double x, double y, double z) {
        double cX = Math.cos(x * -0.5);
        double cY = Math.cos(y * 0.5);
        double cZ = Math.cos(z * 0.5);
        double sX = Math.sin(x * -0.5);
        double sY = Math.sin(y * 0.5);
        double sZ = Math.sin(z * 0.5);
        return new Quaternion(sX * cY * cZ + cX * sY * sZ, cX * sY * cZ - sX * cY * sZ, cX * cY * sZ + sX * sY * cZ, cX * cY * cZ - sX * sY * sZ);
    }

    public static Quaternion globalRotate(Quaternion origin, Quaternion delta) {
        return origin.altMul(delta);
    }

    public static Quaternion localRotate(Quaternion origin, Quaternion delta) {
        return Quaternion.globalRotate(delta, origin);
    }

    public Quaternion add(Quaternion other) {
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        this.w += other.w;
        return this;
    }

    public Quaternion mul(double value) {
        this.x *= value;
        this.y *= value;
        this.z *= value;
        this.w *= value;
        return this;
    }

    public Quaternion mul(Quaternion other) {
        double aX = this.x;
        double aY = this.y;
        double aZ = this.z;
        double aW = this.w;
        double bX = other.x;
        double bY = other.y;
        double bZ = other.z;
        double bW = other.w;
        this.x = aW * bX + aX * bW + aY * bZ - aZ * bY;
        this.y = aW * bY - aX * bZ + aY * bW + aZ * bX;
        this.z = aW * bZ + aX * bY - aY * bX + aZ * bW;
        this.w = aW * bW - aX * bX - aY * bY - aZ * bZ;
        return this;
    }

    public Quaternion normalize() {
        double var0 = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if (var0 > 1.0E-6) {
            double sqrt = TMath.fastInvSqrt(var0);
            this.x *= sqrt;
            this.y *= sqrt;
            this.z *= sqrt;
            this.w *= sqrt;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            this.w = 0.0;
        }
        return this;
    }

    public double dot(Quaternion other) {
        return this.x * other.x + this.y * other.y + this.z * other.z + this.w * other.w;
    }

    public Quaternion altAdd(Quaternion other) {
        Quaternion c = this.copy();
        c.add(other);
        return c;
    }

    public Quaternion altMul(Quaternion other) {
        Quaternion c = this.copy();
        c.mul(other);
        return c;
    }

    public Quaternion altMul(double value) {
        Quaternion c = this.copy();
        c.mul(value);
        return c;
    }

    public Quaternion conjugate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        return this;
    }

    public Quaternion altConjugate() {
        Quaternion c = this.copy();
        return c.conjugate();
    }

    public Quaternion copy() {
        return new Quaternion(this);
    }

    public EulerAngle toEulerAngle() {
        double z;
        double x;
        double x2 = this.x + this.x;
        double y2 = this.y + this.y;
        double z2 = this.z + this.z;
        double xx = this.x * x2;
        double xy = this.x * y2;
        double xz = this.x * z2;
        double yy = this.y * y2;
        double yz = this.y * z2;
        double zz = this.z * z2;
        double wx = this.w * x2;
        double wy = this.w * y2;
        double wz = this.w * z2;
        double m11 = 1.0 - (yy + zz);
        double m12 = xy + wz;
        double m21 = xy - wz;
        double m22 = 1.0 - (xx + zz);
        double m31 = xz + wy;
        double m32 = yz - wx;
        double m33 = 1.0 - (xx + yy);
        double y = TMath.fastAsin(-TMath.clamp(m31, -1.0, 1.0));
        if (Math.abs(m31) < 0.9999999) {
            x = TMath.fastAtan2(m32, m33);
            z = TMath.fastAtan2(m21, m11);
        } else {
            x = 0.0;
            z = TMath.fastAtan2(-m12, m22);
        }
        return new EulerAngle(x, -y, -z);
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public String toString() {
        return "Quaternion(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", w=" + this.getW() + ")";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setW(double w) {
        this.w = w;
    }
}

