/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class OrientedBoundingBox {
    private static final Vector GLOBAL_RIGHT = new Vector(1, 0, 0);
    private static final Vector GLOBAL_UP = new Vector(0, 1, 0);
    private static final Vector GLOBAL_FORWARD = new Vector(0, 0, 1);
    private final Vector origin;
    private final EulerAngle rotation;
    private final Vector right;
    private final Vector up;
    private final Vector forward;
    private final double halfX;
    private final double halfY;
    private final double halfZ;

    public OrientedBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.origin = new Vector((maxX + minX) / 2.0, (maxY + minY) / 2.0, (maxZ + minZ) / 2.0);
        this.rotation = EulerAngle.ZERO;
        this.right = GLOBAL_RIGHT.clone();
        this.up = GLOBAL_UP.clone();
        this.forward = GLOBAL_FORWARD.clone();
        this.halfX = (maxX - minX) / 2.0;
        this.halfY = (maxY - minY) / 2.0;
        this.halfZ = (maxZ - minZ) / 2.0;
    }

    public OrientedBoundingBox(Vector origin, Vector dimension, EulerAngle rotation, float yaw) {
        this.origin = origin.clone();
        this.rotation = TMath.globalRotate(rotation, TMath.makeAngle(0.0, yaw, 0.0));
        this.right = Offset.getRelativeLocation(this.rotation, GLOBAL_RIGHT.clone());
        this.up = Offset.getRelativeLocation(this.rotation, GLOBAL_UP.clone());
        this.forward = Offset.getRelativeLocation(this.rotation, GLOBAL_FORWARD.clone());
        this.halfX = dimension.getX() / 2.0;
        this.halfY = dimension.getY() / 2.0;
        this.halfZ = dimension.getZ() / 2.0;
    }

    public boolean intersects(BoundingBox aabb) {
        return this.intersects(new OrientedBoundingBox(aabb.getCenter(), new Vector(aabb.getWidthX(), aabb.getHeight(), aabb.getWidthZ()), EulerAngle.ZERO, 0.0f));
    }

    public boolean intersects(OrientedBoundingBox obb) {
        Vector traversed = new Vector(obb.origin.getX() - this.origin.getX(), obb.origin.getY() - this.origin.getY(), obb.origin.getZ() - this.origin.getZ());
        for (int i = 0; i < 15; ++i) {
            double proj;
            Vector check = this.getL(i, obb);
            double t = this.projectionOnAxis(traversed, check);
            if (!(t > (proj = this.projectionOnAxis(this.right.clone().multiply(this.halfX), check) + this.projectionOnAxis(this.up.clone().multiply(this.halfY), check) + this.projectionOnAxis(this.forward.clone().multiply(this.halfZ), check) + this.projectionOnAxis(obb.right.clone().multiply(obb.halfX), check) + this.projectionOnAxis(obb.up.clone().multiply(obb.halfY), check) + this.projectionOnAxis(obb.forward.clone().multiply(obb.halfZ), check)))) continue;
            return false;
        }
        return true;
    }

    public RayTraceResult rayTrace(@NotNull Vector start, @NotNull Vector direction, double maxDistance, Consumer<BoundingBox> consumer) {
        EulerAngle inverseRotation = Quaternion.fromEulerAngle(this.rotation).conjugate().toEulerAngle();
        Vector relativeStart = Offset.getRelativeLocation(inverseRotation, start.clone().subtract(this.origin)).add(this.origin);
        Vector relativeDirection = Offset.getRelativeLocation(inverseRotation, direction.clone());
        BoundingBox bb = BoundingBox.of((Vector)this.origin, (double)this.halfX, (double)this.halfY, (double)this.halfZ);
        consumer.accept((Object)bb);
        RayTraceResult result = bb.rayTrace(relativeStart, relativeDirection, maxDistance);
        if (result == null) {
            return null;
        }
        Vector hitPosition = Offset.getRelativeLocation(this.rotation, result.getHitPosition().subtract(this.origin)).add(this.origin);
        return new RayTraceResult(hitPosition, result.getHitBlockFace());
    }

    private double projectionOnAxis(Vector vector, Vector axis) {
        return Math.abs(vector.dot(axis));
    }

    private Vector getL(int i, OrientedBoundingBox other) {
        return switch (i) {
            case 0 -> this.right;
            case 1 -> this.up;
            case 2 -> this.forward;
            case 3 -> other.right;
            case 4 -> other.up;
            case 5 -> other.forward;
            case 6 -> this.right.getCrossProduct(other.right);
            case 7 -> this.right.getCrossProduct(other.up);
            case 8 -> this.right.getCrossProduct(other.forward);
            case 9 -> this.up.getCrossProduct(other.right);
            case 10 -> this.up.getCrossProduct(other.up);
            case 11 -> this.up.getCrossProduct(other.forward);
            case 12 -> this.forward.getCrossProduct(other.right);
            case 13 -> this.forward.getCrossProduct(other.up);
            case 14 -> this.forward.getCrossProduct(other.forward);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
    }

    public void visualize(World world) {
        Vector offsetX = this.right.clone().multiply(this.halfX);
        Vector offsetY = this.up.clone().multiply(this.halfY);
        Vector offsetZ = this.forward.clone().multiply(this.halfZ);
        Vector offsetXN = offsetX.clone().multiply(-1);
        Vector offsetYN = offsetY.clone().multiply(-1);
        Vector offsetZN = offsetZ.clone().multiply(-1);
        this.drawLine(offsetX, offsetY, offsetZ, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(offsetX, offsetYN, offsetZ, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(offsetXN, offsetY, offsetZ, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(offsetXN, offsetYN, offsetZ, world, Color.ORANGE, this.halfZ * 2.0);
        this.drawLine(offsetY, offsetZ, offsetX, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(offsetY, offsetZN, offsetX, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(offsetYN, offsetZ, offsetX, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(offsetYN, offsetZN, offsetX, world, Color.GREEN, this.halfX * 2.0);
        this.drawLine(offsetZ, offsetX, offsetY, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(offsetZ, offsetXN, offsetY, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(offsetZN, offsetX, offsetY, world, Color.AQUA, this.halfY * 2.0);
        this.drawLine(offsetZN, offsetXN, offsetY, world, Color.AQUA, this.halfY * 2.0);
    }

    private void drawLine(Vector offset1, Vector offset2, Vector line, World world, Color color, double dist) {
        Vector offset = offset1.clone().add(offset2);
        Vector pointA = offset.clone().add(line);
        Vector pointB = offset.clone().subtract(line);
        for (double i = 0.0; i < dist; i += 0.1) {
            Vector point = TMath.lerp(pointA, pointB, i / dist);
            world.spawnParticle(Particle.REDSTONE, this.origin.getX() + point.getX(), this.origin.getY() + point.getY(), this.origin.getZ() + point.getZ(), 1, (Object)new Particle.DustOptions(color, 0.2f));
        }
    }

    public String toString() {
        return "OrientedBoundingBox(origin=" + this.origin + ", rotation=" + this.rotation + ", right=" + this.right + ", up=" + this.up + ", forward=" + this.forward + ", halfX=" + this.halfX + ", halfY=" + this.halfY + ", halfZ=" + this.halfZ + ")";
    }
}

