/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Offset {
    public static Vector getRelativeLocation(Vector origin, EulerAngle angle, Vector offset) {
        return origin.add(Offset.getRelativeLocation(angle, offset));
    }

    public static Vector getRelativeLocation(Vector origin, EulerAngle angle, double oX, double oY, double oZ) {
        return Offset.getRelativeLocation(origin, angle, new Vector(oX, oY, oZ));
    }

    public static Vector getRelativeLocation(EulerAngle angle, double oX, double oY, double oZ) {
        return Offset.getRelativeLocation(angle, new Vector(oX, oY, oZ));
    }

    public static Vector getRelativeLocation(EulerAngle angle, Vector offset) {
        return Offset.rotateRoll(Offset.rotateYaw(Offset.rotatePitch(offset, angle.getX()), angle.getY()), angle.getZ());
    }

    public static Vector rotateRoll(Vector vec, double roll) {
        double sin = Math.sin(roll);
        double cos = Math.cos(roll);
        double x = vec.getX() * cos + vec.getY() * sin;
        double y = -vec.getX() * sin + vec.getY() * cos;
        return vec.setX(x).setY(y);
    }

    public static Vector rotatePitch(Vector vec, double pitch) {
        double sin = Math.sin(pitch);
        double cos = Math.cos(pitch);
        double y = vec.getY() * cos - vec.getZ() * sin;
        double z = vec.getY() * sin + vec.getZ() * cos;
        return vec.setY(y).setZ(z);
    }

    public static Vector rotateYaw(Vector vec, double yaw) {
        double sin = Math.sin(yaw);
        double cos = Math.cos(yaw);
        double x = vec.getX() * cos - vec.getZ() * sin;
        double z = vec.getX() * sin + vec.getZ() * cos;
        return vec.setX(x).setZ(z);
    }
}

