/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.math;

import com.ticxo.modelengine.api.utils.math.Quaternion;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Matrix3x3 {
    private double m11;
    private double m12;
    private double m13;
    private double m21;
    private double m22;
    private double m23;
    private double m31;
    private double m32;
    private double m33;

    public Matrix3x3() {
    }

    public void setRow(int row, Vector vector) {
        this.setRow(row, vector.getX(), vector.getY(), vector.getZ());
    }

    public void setRow(int row, double x, double y, double z) {
        switch (row) {
            case 0: {
                this.m11 = x;
                this.m12 = y;
                this.m13 = z;
                break;
            }
            case 1: {
                this.m21 = x;
                this.m22 = y;
                this.m23 = z;
                break;
            }
            case 2: {
                this.m31 = x;
                this.m32 = y;
                this.m33 = z;
            }
        }
    }

    public void setColumn(int col, Vector vector) {
        this.setColumn(col, vector.getX(), vector.getY(), vector.getZ());
    }

    public void setColumn(int col, double x, double y, double z) {
        switch (col) {
            case 0: {
                this.m11 = x;
                this.m21 = y;
                this.m31 = z;
                break;
            }
            case 1: {
                this.m12 = x;
                this.m22 = y;
                this.m32 = z;
                break;
            }
            case 2: {
                this.m13 = x;
                this.m23 = y;
                this.m33 = z;
            }
        }
    }

    public Vector getRow(int row) {
        return switch (row) {
            case 0 -> new Vector(this.m11, this.m12, this.m13);
            case 1 -> new Vector(this.m21, this.m22, this.m23);
            case 2 -> new Vector(this.m31, this.m32, this.m33);
            default -> throw new IllegalStateException("Unexpected value: " + row);
        };
    }

    public Vector getColumn(int col) {
        return switch (col) {
            case 0 -> new Vector(this.m11, this.m21, this.m31);
            case 1 -> new Vector(this.m12, this.m22, this.m32);
            case 2 -> new Vector(this.m13, this.m23, this.m33);
            default -> throw new IllegalStateException("Unexpected value: " + col);
        };
    }

    public EulerAngle toEulerAngle() {
        double z;
        double x;
        double y = TMath.fastAsin(-TMath.clamp(this.m31, -1.0, 1.0));
        if (Math.abs(this.m31) < 0.9999999) {
            x = TMath.fastAtan2(this.m32, this.m33);
            z = TMath.fastAtan2(this.m21, this.m11);
        } else {
            x = 0.0;
            z = TMath.fastAtan2(-this.m12, this.m22);
        }
        return new EulerAngle(x, -y, -z);
    }

    public Quaternion toQuaternion() {
        double z;
        double y;
        double x;
        double w;
        double trace = this.m11 + this.m22 + this.m33;
        if (trace > 0.0) {
            double s = 0.5 * TMath.fastInvSqrt(trace + 1.0);
            w = 0.25 / s;
            x = -(this.m32 - this.m23) * s;
            y = -(this.m13 - this.m31) * s;
            z = -(this.m21 - this.m12) * s;
        } else if (this.m11 > this.m22 && this.m11 > this.m33) {
            double s = 0.5 * TMath.fastInvSqrt(1.0 + this.m11 - this.m22 - this.m33);
            w = (this.m32 - this.m23) * s;
            x = -0.25 / s;
            y = -(this.m12 + this.m21) * s;
            z = -(this.m13 + this.m31) * s;
        } else if (this.m22 > this.m33) {
            double s = 0.5 * TMath.fastInvSqrt(1.0 + this.m22 - this.m11 - this.m33);
            w = -(this.m13 - this.m31) * s;
            x = (this.m12 + this.m21) * s;
            y = 0.25 / s;
            z = (this.m23 + this.m32) * s;
        } else {
            double s = 0.5 * TMath.fastInvSqrt(1.0 + this.m33 - this.m11 - this.m22);
            w = -(this.m21 - this.m12) * s;
            x = (this.m13 + this.m31) * s;
            y = (this.m23 + this.m32) * s;
            z = 0.25 / s;
        }
        return new Quaternion(x, y, z, w);
    }

    public static Matrix3x3 multiply(Matrix3x3 lhs, Matrix3x3 rhs) {
        return new Matrix3x3(lhs.m11 * rhs.m11 + lhs.m12 * rhs.m21 + lhs.m13 * rhs.m31, lhs.m11 * rhs.m12 + lhs.m12 * rhs.m22 + lhs.m13 * rhs.m32, lhs.m11 * rhs.m13 + lhs.m12 * rhs.m23 + lhs.m13 * rhs.m33, lhs.m21 * rhs.m11 + lhs.m22 * rhs.m21 + lhs.m23 * rhs.m31, lhs.m21 * rhs.m12 + lhs.m22 * rhs.m22 + lhs.m23 * rhs.m32, lhs.m21 * rhs.m13 + lhs.m22 * rhs.m23 + lhs.m23 * rhs.m33, lhs.m31 * rhs.m11 + lhs.m32 * rhs.m21 + lhs.m33 * rhs.m31, lhs.m31 * rhs.m12 + lhs.m32 * rhs.m22 + lhs.m33 * rhs.m32, lhs.m31 * rhs.m13 + lhs.m32 * rhs.m23 + lhs.m33 * rhs.m33);
    }

    public static Matrix3x3 rotationAlign(Vector from, Vector to) {
        Vector v = from.getCrossProduct(to);
        double c = from.dot(to);
        double k = 1.0 / (1.0 + c);
        Matrix3x3 mat = new Matrix3x3();
        mat.setRow(0, v.getX() * v.getX() * k + c, v.getY() * v.getX() * k - v.getZ(), v.getZ() * v.getX() * k + v.getY());
        mat.setRow(1, v.getX() * v.getY() * k + v.getZ(), v.getY() * v.getY() * k + c, v.getZ() * v.getY() * k - v.getX());
        mat.setRow(2, v.getX() * v.getZ() * k - v.getY(), v.getY() * v.getZ() * k + v.getX(), v.getZ() * v.getZ() * k + c);
        return mat;
    }

    public static Matrix3x3 fromEulerAngle(EulerAngle angle) {
        double x = angle.getX();
        double y = -angle.getY();
        double z = -angle.getZ();
        double a = Math.cos(x);
        double b = Math.sin(x);
        double c = Math.cos(y);
        double d = Math.sin(y);
        double e = Math.cos(z);
        double f = Math.sin(z);
        double ae = a * e;
        double af = a * f;
        double be = b * e;
        double bf = b * f;
        double m11 = c * e;
        double m12 = be * d - af;
        double m13 = ae * d + bf;
        double m21 = c * f;
        double m22 = bf * d + ae;
        double m23 = af * d - be;
        double m31 = -d;
        double m32 = b * c;
        double m33 = a * c;
        return new Matrix3x3(m11, m12, m13, m21, m22, m23, m31, m32, m33);
    }

    public static Matrix3x3 fromQuaternion(Quaternion q) {
        double x = q.getX();
        double y = q.getY();
        double z = q.getZ();
        double w = q.getW();
        double x2 = x + x;
        double y2 = y + y;
        double z2 = z + z;
        double xx = x * x2;
        double xy = x * y2;
        double xz = x * z2;
        double yy = y * y2;
        double yz = y * z2;
        double zz = z * z2;
        double wx = w * x2;
        double wy = w * y2;
        double wz = w * z2;
        double m11 = 1.0 - (yy + zz);
        double m12 = xy + wz;
        double m13 = xz - wy;
        double m21 = xy - wz;
        double m22 = 1.0 - (xx + zz);
        double m23 = yz + wx;
        double m31 = xz + wy;
        double m32 = yz - wx;
        double m33 = 1.0 - (xx + yy);
        return new Matrix3x3(m11, m12, m13, m21, m22, m23, m31, m32, m33);
    }

    public double getM11() {
        return this.m11;
    }

    public double getM12() {
        return this.m12;
    }

    public double getM13() {
        return this.m13;
    }

    public double getM21() {
        return this.m21;
    }

    public double getM22() {
        return this.m22;
    }

    public double getM23() {
        return this.m23;
    }

    public double getM31() {
        return this.m31;
    }

    public double getM32() {
        return this.m32;
    }

    public double getM33() {
        return this.m33;
    }

    public void setM11(double m11) {
        this.m11 = m11;
    }

    public void setM12(double m12) {
        this.m12 = m12;
    }

    public void setM13(double m13) {
        this.m13 = m13;
    }

    public void setM21(double m21) {
        this.m21 = m21;
    }

    public void setM22(double m22) {
        this.m22 = m22;
    }

    public void setM23(double m23) {
        this.m23 = m23;
    }

    public void setM31(double m31) {
        this.m31 = m31;
    }

    public void setM32(double m32) {
        this.m32 = m32;
    }

    public void setM33(double m33) {
        this.m33 = m33;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Matrix3x3)) {
            return false;
        }
        Matrix3x3 other = (Matrix3x3)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getM11(), other.getM11()) != 0) {
            return false;
        }
        if (Double.compare(this.getM12(), other.getM12()) != 0) {
            return false;
        }
        if (Double.compare(this.getM13(), other.getM13()) != 0) {
            return false;
        }
        if (Double.compare(this.getM21(), other.getM21()) != 0) {
            return false;
        }
        if (Double.compare(this.getM22(), other.getM22()) != 0) {
            return false;
        }
        if (Double.compare(this.getM23(), other.getM23()) != 0) {
            return false;
        }
        if (Double.compare(this.getM31(), other.getM31()) != 0) {
            return false;
        }
        if (Double.compare(this.getM32(), other.getM32()) != 0) {
            return false;
        }
        return Double.compare(this.getM33(), other.getM33()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Matrix3x3;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $m11 = Double.doubleToLongBits(this.getM11());
        result = result * 59 + (int)($m11 >>> 32 ^ $m11);
        long $m12 = Double.doubleToLongBits(this.getM12());
        result = result * 59 + (int)($m12 >>> 32 ^ $m12);
        long $m13 = Double.doubleToLongBits(this.getM13());
        result = result * 59 + (int)($m13 >>> 32 ^ $m13);
        long $m21 = Double.doubleToLongBits(this.getM21());
        result = result * 59 + (int)($m21 >>> 32 ^ $m21);
        long $m22 = Double.doubleToLongBits(this.getM22());
        result = result * 59 + (int)($m22 >>> 32 ^ $m22);
        long $m23 = Double.doubleToLongBits(this.getM23());
        result = result * 59 + (int)($m23 >>> 32 ^ $m23);
        long $m31 = Double.doubleToLongBits(this.getM31());
        result = result * 59 + (int)($m31 >>> 32 ^ $m31);
        long $m32 = Double.doubleToLongBits(this.getM32());
        result = result * 59 + (int)($m32 >>> 32 ^ $m32);
        long $m33 = Double.doubleToLongBits(this.getM33());
        result = result * 59 + (int)($m33 >>> 32 ^ $m33);
        return result;
    }

    public String toString() {
        return "Matrix3x3(m11=" + this.getM11() + ", m12=" + this.getM12() + ", m13=" + this.getM13() + ", m21=" + this.getM21() + ", m22=" + this.getM22() + ", m23=" + this.getM23() + ", m31=" + this.getM31() + ", m32=" + this.getM32() + ", m33=" + this.getM33() + ")";
    }

    public Matrix3x3(double m11, double m12, double m13, double m21, double m22, double m23, double m31, double m32, double m33) {
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
    }
}

