/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.logger;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.logger.LogColor;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;

public class TLogger {
    public static void log() {
        TLogger.log("");
    }

    public static void log(String string) {
        ModelEngineAPI.api.getLogger().log(Level.INFO, string + LogColor.RESET);
    }

    public static void warn(String string) {
        ModelEngineAPI.api.getLogger().log(Level.WARNING, LogColor.YELLOW + string + LogColor.RESET);
    }

    public static void error(String string) {
        ModelEngineAPI.api.getLogger().log(Level.WARNING, LogColor.RED + string + LogColor.RESET);
    }

    public static void log(Object object) {
        TLogger.log(object == null ? "null" : object.toString());
    }

    public static <T> void log(Iterable<T> iterable) {
        TLogger.log(iterable, Object::toString);
    }

    public static <T> void log(Iterable<T> iterable, Function<T, String> toString) {
        String className = iterable.getClass().getSimpleName();
        StringBuilder builder = new StringBuilder();
        builder.append(className).append(":[");
        boolean isFirst = true;
        for (T value : iterable) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(toString.apply(value));
        }
        builder.append("]");
        TLogger.log(builder.toString());
    }

    public static <T> void log(T[] array) {
        TLogger.log(array, Objects::toString);
    }

    public static <T> void log(T[] array, Function<T, String> toString) {
        String className = array.getClass().getSimpleName();
        StringBuilder builder = new StringBuilder();
        builder.append(className).append(":[");
        boolean isFirst = true;
        for (T value : array) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(toString.apply(value));
        }
        builder.append("]");
        TLogger.log(builder.toString());
    }
}

