/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.config;

import com.ticxo.modelengine.api.utils.config.Property;
import org.jetbrains.annotations.Nullable;

public enum ConfigProperty implements Property
{
    ENGINE("Model-Engine"),
    GENERATOR("Model-Generator"),
    CALIBRATOR("Model-Calibrator"),
    EXPERIMENTAL("Experimental-Features"),
    SLERP_MODE(ENGINE, "Slerp-Mode", "SLERP"),
    DEFAULT_NAMES(ENGINE, "Default-Animations"),
    ANIMATION_MODE(ENGINE, "Animation-Mode", "C"),
    MOVE_RESOLUTION(ENGINE, "Movement-Resolution", 0.001),
    COMPRESS_PACKET(ENGINE, "Compress-Packet", true),
    ERROR(GENERATOR, "Enable-Error", true),
    NAMESPACE(GENERATOR, "Namespace", "modelengine"),
    COMPARTMENT_SIZE(GENERATOR, "Compartment-Size", 1000),
    ZIP(GENERATOR, "Create-Zip", true),
    ITEM_MODEL(GENERATOR, "Item-Model", "LEATHER_HORSE_ARMOR"),
    USE_CALIBRATION(CALIBRATOR, "Use-Calibration", true),
    CAL_ANIMATION(CALIBRATOR, "Animation-Sync", 0.685);

    private final String path;
    private final Object def;

    private ConfigProperty(String path) {
        this(path, null);
    }

    private ConfigProperty(ConfigProperty scope, String path) {
        this(scope.getPath() + "." + path, null);
    }

    private ConfigProperty(String path, Object def) {
        this.path = path;
        this.def = def;
    }

    private ConfigProperty(@Nullable ConfigProperty scope, String path, Object def) {
        this(scope.getPath() + "." + path, def);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getDef() {
        return this.def;
    }
}

