/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils;

import com.google.common.io.ByteStreams;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class TFile {
    public static final String SEP = System.getProperty("file.separator");

    public static void copyResource(File file, String path) {
        if (!file.exists()) {
            try {
                FileOutputStream writer = new FileOutputStream(file);
                InputStream reader = ModelEngineAPI.api.getResource(path);
                if (reader != null) {
                    ByteStreams.copy((InputStream)reader, (OutputStream)writer);
                }
                ((OutputStream)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String createPath(String ... path) {
        if (path.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(path[0]);
        for (int i = 1; i < path.length; ++i) {
            builder.append(SEP).append(path[i]);
        }
        return builder.toString();
    }

    public static File createDirectory(File parent, String ... path) {
        File file = new File(parent, TFile.createPath(path));
        if (!file.exists() && !file.mkdirs()) {
            TLogger.log("Failed to create directory.");
        }
        return file;
    }

    public static File createFile(File parent, String ... path) {
        File file = new File(parent, TFile.createPath(path));
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            TLogger.log("Failed to create file.");
        }
        return file;
    }

    public static BufferedImage toImage(String data) {
        String[] d = data.split(",");
        if (d.length > 1) {
            return TFile.rawToImage(d[1]);
        }
        return TFile.rawToImage(data);
    }

    public static BufferedImage rawToImage(String data) {
        try {
            byte[] imageBytes = Base64.getDecoder().decode(data);
            return ImageIO.read(new ByteArrayInputStream(imageBytes));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String removeExtension(String path) {
        int id = path.lastIndexOf(".");
        if (id == -1) {
            return path;
        }
        return path.substring(0, id);
    }

    public static boolean isExtension(String path, String extensions) {
        int id = path.lastIndexOf(".");
        if (id == -1) {
            return false;
        }
        return path.substring(id + 1).equalsIgnoreCase(extensions);
    }
}

