/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.nms.entity.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import java.util.Set;
import org.bukkit.entity.Player;

public class ManualRangeManager
implements RangeManager {
    private final BaseEntity<?> base;
    private final IModel model;
    private final Set<Player> players = Sets.newConcurrentHashSet();
    private int renderDistance;

    public ManualRangeManager(BaseEntity<?> base, IModel model) {
        this.base = base;
        this.model = model;
    }

    @Override
    public void forceSpawn(Player player) {
        if (this.players.contains(player)) {
            return;
        }
        this.players.add(player);
        this.model.showToPlayer(player);
    }

    @Override
    public void updatePlayer(Player player) {
        double dSqr = player.getLocation().distanceSquared(this.base.getLocation());
        if (dSqr > (double)(this.renderDistance * this.renderDistance)) {
            this.removePlayer(player);
        } else {
            this.forceSpawn(player);
        }
    }

    @Override
    public void removePlayer(Player player) {
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        this.model.hideFromPlayer(player);
    }

    @Override
    public Set<Player> getPlayerInRange() {
        return ImmutableSet.copyOf(this.players);
    }

    public IModel getModel() {
        return this.model;
    }

    @Override
    public int getRenderDistance() {
        return this.renderDistance;
    }

    @Override
    public void setRenderDistance(int renderDistance) {
        this.renderDistance = renderDistance;
    }
}

