/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.mount.controller.flying;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.controller.AbstractMountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import org.bukkit.util.Vector;

public class FlyingMountController
extends AbstractMountController {
    @Override
    public void updateDriverMovement(MoveController controller, ModeledEntity model) {
        controller.nullifyFallDistance();
        Vector original = controller.getVelocity();
        controller.setVelocity(original.getX(), 0.0, original.getZ());
        BaseEntity<?> base = model.getBase();
        if (this.input.isSneak()) {
            if (!controller.isOnGround()) {
                controller.addVelocity(0.0, -controller.getSpeed(), 0.0);
            } else {
                model.getMountManager().removeDriver();
                controller.move(0.0f, 0.0f, 0.0f);
                return;
            }
        }
        if (this.input.isJump()) {
            controller.addVelocity(0.0, controller.getSpeed(), 0.0);
        }
        controller.move(this.input.getSide(), this.input.getFront(), 1.0f);
        if (this.input.getSide() != 0.0f || this.input.getFront() != 0.0f) {
            model.setState(ModelState.WALK);
        } else {
            model.setState(ModelState.IDLE);
        }
    }

    @Override
    public void updatePassengerMovement(MoveController controller, ModeledEntity model) {
        if (this.input.isSneak() && model.getBase().isOnGround()) {
            model.getMountManager().removePassengers(this.entity);
        }
    }
}

