/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.mount;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.command.annotations.CommandAttribute;
import com.ticxo.modelengine.api.events.ModelDismountEvent;
import com.ticxo.modelengine.api.events.ModelMountEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.controller.MountController;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandAccessible
public class MountManager {
    private final ModeledEntity model;
    private boolean canSteer = true;
    private boolean canRide = true;
    private Entity driver = null;
    private Mountable driverBone;
    private MountController driverController;
    private final Map<Entity, Mountable> passengers = Maps.newConcurrentMap();
    private final Map<UUID, MountController> controllers = Maps.newConcurrentMap();
    private final Set<UUID> nullifyDamage = Sets.newConcurrentHashSet();

    public MountManager(ModeledEntity model) {
        this.model = model;
    }

    @CommandAttribute(tag="steer", hints={"[B]flag"})
    public void setCanSteer(boolean flag) {
        this.canSteer = flag;
    }

    @CommandAttribute(tag="ride", hints={"[B]flag"})
    public void setCanRide(boolean flag) {
        this.canRide = flag;
    }

    public void setDriverBone(Mountable driverBone) {
        if (driverBone.isDriverBone()) {
            this.driverBone = driverBone;
        }
    }

    @CommandAttribute(tag="drive", hints={"[P]driver", "[C]controller"})
    public void setDriver(@NotNull Entity driver, MountController controller) throws IllegalStateException {
        if (!this.canSteer || this.driverBone == null) {
            return;
        }
        if (ModelEngineAPI.getMountPair(driver.getUniqueId()) != null) {
            throw new IllegalStateException("Please dismount the rider before mounting it onto a different model.");
        }
        ModelMountEvent mountEvent = new ModelMountEvent(this.model, driver, true, this.driverBone);
        ModelEngineAPI.callEvent(mountEvent);
        if (mountEvent.isCancelled()) {
            return;
        }
        if (this.driver != null) {
            this.removeDriver();
        }
        this.driver = driver;
        controller.setEntity(driver);
        this.driverController = controller;
        this.registerPair(driver, controller);
        this.driverBone.mountRiders(driver);
        this.setCollidable(driver, false);
    }

    @CommandAttribute(tag="remove_driver")
    public void removeDriver() {
        if (this.driver == null || this.driverBone == null) {
            return;
        }
        ModelDismountEvent dismountEvent = new ModelDismountEvent(this.model, this.driver, true, this.driverBone);
        ModelEngineAPI.callEvent(dismountEvent);
        if (dismountEvent.isCancelled()) {
            return;
        }
        this.driverBone.dismountRider(this.driver);
        this.setCollidable(this.driver, true);
        this.unregisterPair(this.driver);
        this.driverController = null;
        this.driver = null;
    }

    public boolean isControlled() {
        return this.driver != null;
    }

    @CommandAttribute(tag="sit", hints={"[S]modelId", "[S]seatId", "[P]passenger", "[C]controller"})
    public void addPassengerToSeat(String modelId, String seatId, Entity passenger, MountController controller) throws IllegalStateException {
        if (!this.canRide) {
            return;
        }
        if (ModelEngineAPI.getMountPair(passenger.getUniqueId()) != null) {
            throw new IllegalStateException("Please dismount the rider before mounting it onto a different model.");
        }
        Mountable mountable = this.getMountable(modelId, seatId);
        if (mountable == null || mountable.isDriverBone()) {
            return;
        }
        ModelMountEvent mountEvent = new ModelMountEvent(this.model, passenger, false, mountable);
        ModelEngineAPI.callEvent(mountEvent);
        if (mountEvent.isCancelled()) {
            return;
        }
        mountable.mountRiders(passenger);
        this.passengers.put(passenger, mountable);
        controller.setEntity(passenger);
        this.controllers.put(passenger.getUniqueId(), controller);
        this.registerPair(passenger, controller);
        this.setCollidable(passenger, false);
    }

    public void removePassenger(Entity entity) {
        Mountable mountable = this.passengers.get(entity);
        if (mountable == null) {
            return;
        }
        ModelDismountEvent dismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
        ModelEngineAPI.callEvent(dismountEvent);
        if (dismountEvent.isCancelled()) {
            return;
        }
        mountable.dismountRider(entity);
        this.removePassengerReference(entity);
        this.unregisterPair(entity);
        this.setCanDamageMount(entity.getUniqueId(), true);
        this.setCollidable(entity, true);
    }

    public void removePassengers(Entity ... entities) {
        for (Entity entity : entities) {
            this.removePassenger(entity);
        }
    }

    public void removePassengersOnSeat(String modelId, String seatId, Entity ... passengers) {
        Mountable mountable = this.getMountable(modelId, seatId);
        if (mountable == null) {
            return;
        }
        Set<Entity> riders = mountable.getRiders();
        for (Entity entity : passengers) {
            if (!riders.contains(entity)) continue;
            ModelDismountEvent dismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
            ModelEngineAPI.callEvent(dismountEvent);
            if (dismountEvent.isCancelled()) continue;
            mountable.dismountRider(entity);
            this.removePassengerReference(entity);
            this.unregisterPair(entity);
            this.setCanDamageMount(entity.getUniqueId(), true);
            this.setCollidable(entity, true);
        }
    }

    public void clearPassengersOnSeat(String modelId, String seatId) {
        Mountable mountable = this.getMountable(modelId, seatId);
        if (mountable == null) {
            return;
        }
        for (Entity entity : mountable.getRiders()) {
            ModelDismountEvent dismountEvent = new ModelDismountEvent(this.model, entity, false, mountable);
            ModelEngineAPI.callEvent(dismountEvent);
            this.removePassengerReference(entity);
            this.unregisterPair(entity);
            this.setCanDamageMount(entity.getUniqueId(), true);
            this.setCollidable(entity, true);
        }
        mountable.clearRiders();
    }

    @CommandAttribute(tag="dismount_all")
    public void dismountAll() {
        this.removeDriver();
        this.dismountAllPassengers();
    }

    @CommandAttribute(tag="dismount_all_passengers")
    public void dismountAllPassengers() {
        Set mounts = Sets.newConcurrentHashSet();
        mounts.addAll(this.passengers.values());
        mounts.forEach(Mountable::clearRiders);
        this.passengers.keySet().forEach(entity -> {
            this.unregisterPair((Entity)entity);
            this.setCanDamageMount(entity.getUniqueId(), true);
            this.setCollidable((Entity)entity, true);
        });
        this.passengers.clear();
        this.controllers.clear();
    }

    public void removeRiders(Entity ... riders) {
        for (Entity rider : riders) {
            if (rider == this.driver) {
                this.removeDriver();
                continue;
            }
            this.removePassenger(rider);
        }
    }

    public boolean hasRider(Entity rider) {
        return this.driver == rider || this.passengers.containsKey(rider);
    }

    public void setCanDamageMount(UUID uuid, boolean flag) {
        if (flag) {
            this.nullifyDamage.remove(uuid);
        } else {
            this.nullifyDamage.add(uuid);
        }
    }

    public boolean isDamageNullified(UUID uuid) {
        return this.nullifyDamage.contains(uuid);
    }

    public Set<Entity> getPassengersOnSeat(String modelId, String seatId) {
        Mountable mountable = this.getMountable(modelId, seatId);
        return mountable == null ? ImmutableSet.of() : mountable.getRiders();
    }

    public boolean hasPassengers() {
        return !this.passengers.isEmpty();
    }

    public Map<Entity, Mountable> getPassengers() {
        return ImmutableMap.copyOf(this.passengers);
    }

    public Mountable getMountedBone(Entity entity) {
        return this.passengers.get(entity);
    }

    public MountController getController(UUID uuid) {
        return this.controllers.get(uuid);
    }

    protected void registerPair(Entity entity, MountController controller) {
        ModelEngineAPI.registerMountedPair(entity, this.model, controller);
    }

    protected void unregisterPair(Entity entity) {
        ModelEngineAPI.unregisterMountedPair(entity.getUniqueId());
    }

    protected void setCollidable(Entity entity, boolean flag) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.model.getBase().setCollidableToLiving(living, flag);
        }
    }

    protected void removePassengerReference(Entity entity) {
        this.passengers.remove(entity);
        this.controllers.remove(entity.getUniqueId());
    }

    @Nullable
    protected Mountable getMountable(String modelId, String seatId) {
        ActiveModel activeModel = this.model.getModel(modelId);
        if (activeModel == null) {
            return null;
        }
        return (Mountable)activeModel.getMountHandler().getBones().get(seatId);
    }

    public ModeledEntity getModel() {
        return this.model;
    }

    public boolean isCanSteer() {
        return this.canSteer;
    }

    public boolean isCanRide() {
        return this.canRide;
    }

    public Entity getDriver() {
        return this.driver;
    }

    public Mountable getDriverBone() {
        return this.driverBone;
    }

    public MountController getDriverController() {
        return this.driverController;
    }
}

