/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.vfx.VFX;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VFXTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final Map<Integer, UUID> entityIdLookup = Maps.newConcurrentMap();
    private final Map<UUID, VFX> uuidLookup = Maps.newConcurrentMap();

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void run() {
        for (UUID id : this.uuidLookup.keySet()) {
            VFX entity = this.uuidLookup.get(id);
            if (entity.tick()) continue;
            entity.destroy();
            this.entityIdLookup.remove(entity.getBase().getEntityId());
            this.uuidLookup.remove(id);
        }
    }

    public void registerVFX(BaseEntity<?> base, VFX entity) {
        this.entityIdLookup.put(base.getEntityId(), base.getUniqueId());
        this.uuidLookup.put(base.getUniqueId(), entity);
    }

    public void removeVFX(UUID id) {
        VFX model = this.uuidLookup.remove(id);
        if (model == null) {
            return;
        }
        this.entityIdLookup.remove(model.getBase().getEntityId());
        model.destroy();
    }

    public VFX getVFX(int id) {
        return this.entityIdLookup.containsKey(id) ? this.getVFX(this.entityIdLookup.get(id)) : null;
    }

    public VFX getVFX(UUID id) {
        return this.uuidLookup.get(id);
    }

    public boolean isVFX(int id) {
        return this.entityIdLookup.containsKey(id) && this.isVFX(this.entityIdLookup.get(id));
    }

    public boolean isVFX(UUID id) {
        return this.uuidLookup.containsKey(id);
    }

    public VFXTicker(ModelEngineAPI api) {
        this.api = api;
    }
}

