/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.utils.data.EntityData;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ModelTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final Map<Integer, UUID> entityIdLookup = Maps.newConcurrentMap();
    private final Map<UUID, ModeledEntity> uuidLookup = Maps.newConcurrentMap();
    private final Map<UUID, SubHitbox> subHitboxLookup = Maps.newConcurrentMap();
    private final Map<Runnable, Long> queuedTasks = Maps.newConcurrentMap();

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void queueTask(Runnable task) {
        this.queuedTasks.put(task, System.currentTimeMillis());
    }

    public void run() {
        long currentTime = System.currentTimeMillis();
        for (Runnable task : this.queuedTasks.keySet()) {
            long time = this.queuedTasks.get(task);
            if (currentTime - time < 50L) continue;
            task.run();
            this.queuedTasks.remove(task);
        }
        for (UUID id : this.uuidLookup.keySet()) {
            ModeledEntity entity = this.uuidLookup.get(id);
            if (entity == null || entity.tick()) continue;
            entity.getMountManager().dismountAll();
            entity.destroy();
            this.entityIdLookup.remove(entity.getBase().getEntityId());
            this.uuidLookup.remove(id);
        }
    }

    public void registerModeledEntity(BaseEntity<?> base, ModeledEntity entity) {
        this.entityIdLookup.put(base.getEntityId(), base.getUniqueId());
        this.uuidLookup.put(base.getUniqueId(), entity);
    }

    public void removeModeledEntity(UUID id) {
        ModeledEntity model = this.uuidLookup.remove(id);
        if (model == null) {
            return;
        }
        this.entityIdLookup.remove(model.getBase().getEntityId());
        model.destroy();
    }

    public ModeledEntity getModeledEntity(int id) {
        return this.entityIdLookup.containsKey(id) ? this.getModeledEntity(this.entityIdLookup.get(id)) : null;
    }

    public ModeledEntity getModeledEntity(UUID id) {
        return this.uuidLookup.get(id);
    }

    public boolean isModeledEntity(int id) {
        return this.entityIdLookup.containsKey(id) && this.isModeledEntity(this.entityIdLookup.get(id));
    }

    public boolean isModeledEntity(UUID id) {
        return this.uuidLookup.containsKey(id);
    }

    public void registerSubHitbox(UUID uuid, SubHitbox subHitbox) {
        this.subHitboxLookup.put(uuid, subHitbox);
    }

    public void registerSubHitbox(SubHitbox subHitbox) {
        this.subHitboxLookup.put(subHitbox.getSubHitboxEntity().getUniqueId(), subHitbox);
    }

    public void removeSubHitbox(UUID uuid) {
        this.subHitboxLookup.remove(uuid);
    }

    public SubHitbox getSubHitboxBone(UUID uuid) {
        return this.subHitboxLookup.get(uuid);
    }

    public boolean isSubHitbox(UUID uuid) {
        return this.subHitboxLookup.containsKey(uuid);
    }

    public boolean isModeledEntityOrSubHitbox(UUID uuid) {
        return this.isModeledEntity(uuid) || this.isSubHitbox(uuid);
    }

    public void saveAllModels() {
        for (ModeledEntity model : this.uuidLookup.values()) {
            Entity entity;
            Object obj = model.getBase().getOriginal();
            if (!(obj instanceof Entity) || (entity = (Entity)obj) instanceof Player) continue;
            EntityData data = new EntityData();
            data.save(model);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson((Object)data));
        }
    }

    public Set<UUID> getAllModeledEntityUUID() {
        return this.uuidLookup.keySet();
    }

    public ModelTicker(ModelEngineAPI api) {
        this.api = api;
    }
}

