/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.jetbrains.annotations.Nullable;

public class InteractionTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final WorldHandler worldHandler;
    private final ModelTicker modelTicker;
    private final DynamicHitbox dynamicHitbox;
    private final Map<Integer, Integer> playerRelay = Maps.newConcurrentMap();

    public InteractionTicker(ModelEngineAPI api) {
        this.api = api;
        this.worldHandler = api.getNms().getWorldHandler();
        this.modelTicker = ModelEngineAPI.getModelTicker();
        this.dynamicHitbox = ModelEngineAPI.getEntityHandler().getDynamicHitbox();
    }

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void run() {
        block4: for (Player player : Bukkit.getOnlinePlayers()) {
            double range = 3.0;
            switch (player.getGameMode()) {
                case SPECTATOR: {
                    this.setRelay(player, null);
                    this.dynamicHitbox.updateInactive(player);
                    continue block4;
                }
                case CREATIVE: {
                    range = 5.0;
                }
            }
            Location eye = player.getEyeLocation();
            RayTraceResult result = this.worldHandler.asyncRayTrace(eye, eye.getDirection(), range, FluidCollisionMode.NEVER, false, 0.0, entity -> {
                SubHitbox subHitbox = this.modelTicker.getSubHitboxBone(entity.getUniqueId());
                if (subHitbox != null && subHitbox.getSubHitboxEntity().getRelayed().getEntityId() == player.getEntityId()) {
                    return false;
                }
                return entity != player;
            });
            if (result == null) {
                this.setRelay(player, null);
                this.dynamicHitbox.updateInactive(player);
                continue;
            }
            Entity hitEntity = result.getHitEntity();
            if (hitEntity == null) {
                this.setRelay(player, null);
                this.dynamicHitbox.updateInactive(player);
                continue;
            }
            Integer id = this.modelTicker.isModeledEntityOrSubHitbox(hitEntity.getUniqueId()) ? Integer.valueOf(hitEntity.getEntityId()) : null;
            this.setRelay(player, id);
            if (this.modelTicker.isSubHitbox(hitEntity.getUniqueId())) {
                this.dynamicHitbox.updateActive(player, result);
                continue;
            }
            this.dynamicHitbox.updateInactive(player);
        }
    }

    public void setRelay(Player player, @Nullable Integer relayedId) {
        int playerId = player.getEntityId();
        boolean hasTarget = this.playerRelay.containsKey(player.getEntityId());
        if (relayedId == null) {
            if (hasTarget) {
                this.playerRelay.remove(playerId);
            }
        } else if (!hasTarget || !this.playerRelay.get(playerId).equals(relayedId)) {
            this.playerRelay.put(playerId, relayedId);
        }
    }

    public Integer getRelayedId(int id) {
        return this.playerRelay.get(id);
    }
}

