/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.handler;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import java.util.Map;
import org.bukkit.entity.Player;

public abstract class AbstractSpecialBoneHandler<T extends ModelBone, R extends FakeEntity> {
    protected final ActiveModel model;
    protected final Map<String, T> bones = Maps.newConcurrentMap();
    protected final Map<String, R> fakeEntity = Maps.newConcurrentMap();

    public AbstractSpecialBoneHandler(ActiveModel model) {
        this.model = model;
    }

    public abstract void registerSpecialBone(T var1);

    public void unregisterSpecialBone(String bone) {
        this.bones.remove(bone);
        this.fakeEntity.remove(bone);
    }

    public void initialize() {
        this.fakeEntity.values().forEach(fakeEntity -> {
            fakeEntity.initialize();
            fakeEntity.spawn();
        });
    }

    public void spawn() {
        this.fakeEntity.values().forEach(FakeEntity::spawn);
    }

    public void spawn(Player player) {
        try {
            this.fakeEntity.values().forEach(fakeEntity -> fakeEntity.spawn(player));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void despawn() {
        this.fakeEntity.values().forEach(FakeEntity::despawn);
    }

    public void despawn(Player player) {
        this.fakeEntity.values().forEach(fakeEntity -> fakeEntity.despawn(player));
    }

    public void update() {
        this.fakeEntity.values().forEach(FakeEntity::update);
    }

    public void updateReference() {
        this.bones.keySet().forEach(boneId -> {
            ModelBone bone = (ModelBone)this.bones.get(boneId);
            FakeEntity fake = (FakeEntity)this.fakeEntity.get(boneId);
            fake.setBone(bone);
        });
    }

    public ActiveModel getModel() {
        return this.model;
    }

    public Map<String, T> getBones() {
        return this.bones;
    }

    public Map<String, R> getFakeEntity() {
        return this.fakeEntity;
    }
}

