/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.generator.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.error.IError;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public class ModelBlueprint {
    private String modelId;
    private Hitbox mainHitbox;
    private final Map<String, Hitbox> subHitboxes = Maps.newConcurrentMap();
    private final Map<String, Integer> itemIds = Maps.newConcurrentMap();
    private final Map<String, BlueprintBone> bones = Maps.newConcurrentMap();
    private final transient Map<UUID, String> finalBoneNames = Maps.newConcurrentMap();
    private final Map<String, BlueprintAnimation> animations = Maps.newLinkedHashMap();
    private final Map<String, String> animationsPlaceholders = Maps.newLinkedHashMap();
    private transient Map<String, BlueprintBone> flatMap;

    public void constructFlatBoneMap() {
        ConcurrentMap tempMap = Maps.newConcurrentMap();
        HashSet<BlueprintBone> bones = new HashSet<BlueprintBone>(this.bones.values());
        HashSet<BlueprintBone> buffer = new HashSet<BlueprintBone>();
        while (!bones.isEmpty()) {
            for (BlueprintBone bone : bones) {
                buffer.addAll(bone.getChildren());
                if (tempMap.containsKey(bone.getName())) {
                    IError.DUPE_NAME.log();
                    continue;
                }
                tempMap.put(bone.getName(), bone);
            }
            bones.clear();
            bones.addAll(buffer);
            buffer.clear();
        }
        this.flatMap = ImmutableMap.copyOf((Map)tempMap);
    }

    public String getModelId() {
        return this.modelId;
    }

    public Hitbox getMainHitbox() {
        return this.mainHitbox;
    }

    public Map<String, Hitbox> getSubHitboxes() {
        return this.subHitboxes;
    }

    public Map<String, Integer> getItemIds() {
        return this.itemIds;
    }

    public Map<String, BlueprintBone> getBones() {
        return this.bones;
    }

    public Map<UUID, String> getFinalBoneNames() {
        return this.finalBoneNames;
    }

    public Map<String, BlueprintAnimation> getAnimations() {
        return this.animations;
    }

    public Map<String, String> getAnimationsPlaceholders() {
        return this.animationsPlaceholders;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setMainHitbox(Hitbox mainHitbox) {
        this.mainHitbox = mainHitbox;
    }

    public Map<String, BlueprintBone> getFlatMap() {
        return this.flatMap;
    }
}

