/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.DefaultBodyRotationController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;

public class BukkitPlayer
implements BaseEntity<Player> {
    private final Player original;
    private RangeManager rangeManager;
    private Double stepHeight;
    private Hitbox hitbox;
    private final ModelHitbox modelHitbox;

    public BukkitPlayer(@NotNull Player entity) {
        this.original = entity;
        this.modelHitbox = ModelEngineAPI.getEntityHandler().createModelHitbox(this);
    }

    @Override
    public MoveController wrapMoveControl() {
        return new EmptyMoveController();
    }

    @Override
    public LookController wrapLookControl() {
        return new EmptyLookController();
    }

    @Override
    public BodyRotationController wrapBodyRotationControl() {
        DefaultBodyRotationController bodyRotationController = new DefaultBodyRotationController(this);
        bodyRotationController.setMaxHeadAngle(75.0f);
        bodyRotationController.setMaxBodyAngle(75.0f);
        bodyRotationController.setPlayerMode(true);
        return bodyRotationController;
    }

    @Override
    public void wrapNavigation() {
    }

    @Override
    public RangeManager wrapRangeManager(IModel model) {
        if (this.rangeManager != null) {
            return this.rangeManager;
        }
        this.rangeManager = ModelEngineAPI.getEntityHandler().wrapRangeManager((Entity)this.original);
        return this.rangeManager;
    }

    @Override
    public boolean onHurt(IDamageSource damageSource, float damage) {
        return ModelEngineAPI.getEntityHandler().hurt((Entity)this.original, damageSource, damage);
    }

    @Override
    public void onInteract(Player player, EquipmentSlot hand) {
        throw new IllegalCallerException("Sub-hitbox interact request should not be relayed to BaseEntity when entity exists in world.");
    }

    @Override
    public void setHitbox(Hitbox hitbox) {
        if (hitbox == null) {
            return;
        }
        this.hitbox = hitbox.clone();
        ModelEngineAPI.getEntityHandler().setHitbox((Entity)this.original, hitbox);
        this.getModelHitbox().refresh();
    }

    @Override
    public void setStepHeight(double height) {
        this.stepHeight = height;
        ModelEngineAPI.getEntityHandler().setStepHeight((Entity)this.original, height);
    }

    @Override
    public void setCollidableToLiving(LivingEntity living, boolean isRemove) {
        if (isRemove) {
            living.getCollidableExemptions().remove(this.original.getUniqueId());
        } else {
            living.getCollidableExemptions().add(this.original.getUniqueId());
        }
    }

    @Override
    public void broadcastSpawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastSpawnPacket(this, true);
    }

    @Override
    public void broadcastDespawnPacket() {
        ModelEngineAPI.getEntityHandler().broadcastDespawnPacket(this, true);
    }

    @Override
    public int getEntityId() {
        return this.original.getEntityId();
    }

    @Override
    public UUID getUniqueId() {
        return this.original.getUniqueId();
    }

    @Override
    public Location getLocation() {
        return this.original.getLocation();
    }

    @Override
    public World getWorld() {
        return this.original.getWorld();
    }

    @Override
    public boolean isDead() {
        return this.original.isDead();
    }

    @Override
    public boolean isGlowing() {
        return this.original.isGlowing();
    }

    @Override
    public boolean isOnGround() {
        return this.original.isOnGround();
    }

    @Override
    public boolean isMoving() {
        return ModelEngineAPI.getEntityHandler().isMoving((Entity)this.original);
    }

    @Override
    public void setYHeadRot(float rot) {
        ModelEngineAPI.getEntityHandler().setYHeadRot((Entity)this.original, rot);
    }

    @Override
    public float getYHeadRot() {
        return ModelEngineAPI.getEntityHandler().getYHeadRot((Entity)this.original);
    }

    @Override
    public float getXHeadRot() {
        return ModelEngineAPI.getEntityHandler().getXHeadRot((Entity)this.original);
    }

    @Override
    public void setYBodyRot(float rot) {
        ModelEngineAPI.getEntityHandler().setYBodyRot((Entity)this.original, rot);
    }

    @Override
    public float getYBodyRot() {
        return ModelEngineAPI.getEntityHandler().getYBodyRot((Entity)this.original);
    }

    @Override
    public List<Entity> getPassengers() {
        return this.original.getPassengers();
    }

    @Override
    public Player getOriginal() {
        return this.original;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public Double getStepHeight() {
        return this.stepHeight;
    }

    @Override
    public Hitbox getHitbox() {
        return this.hitbox;
    }

    @Override
    public ModelHitbox getModelHitbox() {
        return this.modelHitbox;
    }
}

