/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.command;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.command.annotations.CommandAttribute;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.mount.controller.MountController;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class CommandParser {
    private static final Map<Class<?>, Function<String, ?>> parsers = Maps.newConcurrentMap();
    private static final Map<Class<?>, TabCompleter> tabCompleter = Maps.newConcurrentMap();

    public static void execute(Object target, String ... args) {
        try {
            Set clazzList = Sets.newConcurrentHashSet();
            block2: for (int i = 0; i < args.length; ++i) {
                CommandAccessible accessible = target.getClass().getAnnotation(CommandAccessible.class);
                if (accessible == null) {
                    return;
                }
                String arg = args[i];
                clazzList.clear();
                clazzList.add(target.getClass());
                clazzList.addAll(List.of(accessible.value()));
                for (Class clazz : clazzList) {
                    for (Method method : clazz.getMethods()) {
                        CommandAttribute attribute = method.getAnnotation(CommandAttribute.class);
                        if (attribute == null || !attribute.tag().equals(arg)) continue;
                        Class<?>[] params = method.getParameterTypes();
                        Object[] paramValues = new Object[method.getParameterCount()];
                        for (int j = 0; j < params.length; ++j) {
                            if (++i >= args.length) {
                                return;
                            }
                            paramValues[j] = CommandParser.tryParse(params[j], args[i]);
                        }
                        Object result = method.invoke(target, paramValues);
                        if (method.getReturnType() == Void.TYPE) {
                            return;
                        }
                        target = result;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static List<String> tabComplete(Object target, String ... args) {
        Class<?> targetClass = target.getClass();
        ArrayList<String> methods = new ArrayList<String>();
        Set clazzList = Sets.newConcurrentHashSet();
        block0: for (int i = 0; i < args.length; ++i) {
            CommandAccessible accessible = targetClass.getAnnotation(CommandAccessible.class);
            if (accessible == null) {
                return List.of();
            }
            String arg = args[i];
            methods.clear();
            clazzList.clear();
            clazzList.add(targetClass);
            clazzList.addAll(List.of(accessible.value()));
            for (Class clazz : clazzList) {
                for (Method method : clazz.getMethods()) {
                    CommandAttribute attribute = method.getAnnotation(CommandAttribute.class);
                    if (attribute == null) continue;
                    methods.add(attribute.tag());
                    if (!attribute.tag().equals(arg) || i >= args.length - 1) continue;
                    int paramIndex = i + method.getParameterCount();
                    if (paramIndex < args.length - 1) {
                        targetClass = method.getReturnType();
                        i = paramIndex;
                        continue block0;
                    }
                    StringBuilder builder = new StringBuilder();
                    String[] hints = attribute.hints();
                    Class<?>[] paramsClass = method.getParameterTypes();
                    if (hints.length > 0) {
                        for (j = args.length - 2 - i; j < hints.length; ++j) {
                            builder.append(hints[j]).append(" ");
                        }
                    } else {
                        for (j = args.length - 2 - i; j < paramsClass.length; ++j) {
                            builder.append(paramsClass[j].getSimpleName()).append(" ");
                        }
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(builder.toString().trim());
                    Class<?> paramC = paramsClass[args.length - 2 - i];
                    TabCompleter t = tabCompleter.get(paramC);
                    if (t != null) {
                        list.addAll(t.getSuggestions());
                    }
                    return list;
                }
            }
        }
        String lastArg = args[args.length - 1];
        methods.removeIf(s -> !s.startsWith(lastArg));
        return methods;
    }

    public static Object tryParse(Class<?> clazz, String value) {
        Function<String, ?> parser = parsers.get(clazz);
        if (parser != null) {
            try {
                return parser.apply(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static List<String> getPlayers() {
        ArrayList<String> tabs = new ArrayList<String>();
        Bukkit.getOnlinePlayers().forEach(player -> tabs.add(player.getName()));
        return tabs;
    }

    static {
        parsers.put(String.class, value -> value);
        parsers.put(Integer.TYPE, Integer::parseInt);
        parsers.put(Integer.class, Integer::parseInt);
        parsers.put(Double.TYPE, Double::parseDouble);
        parsers.put(Double.class, Double::parseDouble);
        parsers.put(Float.TYPE, Float::parseFloat);
        parsers.put(Float.class, Float::parseFloat);
        parsers.put(Boolean.TYPE, Boolean::parseBoolean);
        parsers.put(Boolean.class, Boolean::parseBoolean);
        parsers.put(Player.class, Bukkit::getPlayer);
        parsers.put(Entity.class, Bukkit::getPlayer);
        parsers.put(ActiveModel.class, ModelEngineAPI::createActiveModel);
        parsers.put(MountController.class, s -> ModelEngineAPI.getControllerRegistry().get((String)s));
        tabCompleter.put(Player.class, CommandParser::getPlayers);
        tabCompleter.put(Entity.class, CommandParser::getPlayers);
        tabCompleter.put(ActiveModel.class, () -> new ArrayList<String>(ModelEngineAPI.api.getModelRegistry().getAllBlueprintId()));
        tabCompleter.put(MountController.class, () -> new ArrayList<String>(ModelEngineAPI.getControllerRegistry().getKeys()));
    }

    @FunctionalInterface
    public static interface TabCompleter {
        public List<String> getSuggestions();
    }
}

