/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.timeline;

import com.google.common.collect.ImmutableList;
import com.ticxo.modelengine.api.animation.keyframe.AbstractKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.ParticleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.PositionKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.RotationKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.ScaleKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.SoundKeyframe;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class Timeline {
    private final TreeMap<Double, PositionKeyframe> position = new TreeMap();
    private final TreeMap<Double, RotationKeyframe> rotation = new TreeMap();
    private final TreeMap<Double, ScaleKeyframe> scale = new TreeMap();
    private final TreeMap<Double, ParticleKeyframe> particle = new TreeMap();
    private final TreeMap<Double, SoundKeyframe> sound = new TreeMap();
    private final TreeMap<Double, ScriptKeyframe> script = new TreeMap();

    public void addPositionFrame(double frame, Vector vector, KeyframeType type) {
        this.position.put(frame, new PositionKeyframe(vector, type));
    }

    public void addRotationFrame(double frame, EulerAngle angle, KeyframeType type) {
        this.rotation.put(frame, new RotationKeyframe(angle, type));
    }

    public void addScaleFrame(double frame, Vector vector, KeyframeType type) {
        this.scale.put(frame, new ScaleKeyframe(vector, type));
    }

    public void addParticleFrame(double frame, List<ParticleKeyframe.Particles> particles) {
        this.particle.put(frame, new ParticleKeyframe((List<ParticleKeyframe.Particles>)ImmutableList.copyOf(particles)));
    }

    public void addSoundFrame(double frame, List<SoundKeyframe.Sounds> sounds) {
        this.sound.put(frame, new SoundKeyframe((List<SoundKeyframe.Sounds>)ImmutableList.copyOf(sounds)));
    }

    public void addScriptFrame(double frame, List<ScriptKeyframe.Script> scripts) {
        this.script.put(frame, new ScriptKeyframe((List<ScriptKeyframe.Script>)ImmutableList.copyOf(scripts)));
    }

    public Vector getPositionFrame(double time) {
        double lastTime;
        if (this.position.isEmpty()) {
            return new Vector();
        }
        if (this.position.containsKey(time)) {
            return ((Vector)this.position.get(time).getValue()).clone();
        }
        double nextTime = this.getHigherKey(this.position, time);
        if (nextTime == (lastTime = this.getLowerKey(this.position, time))) {
            return ((Vector)this.position.get(lastTime).getValue()).clone();
        }
        double t = (time - lastTime) / (nextTime - lastTime);
        PositionKeyframe nextVector = this.position.get(nextTime);
        PositionKeyframe lastVector = this.position.get(lastTime);
        switch (this.getType(lastVector, nextVector)) {
            case LINEAR: {
                return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
            }
            case SMOOTH: {
                double nextControlTime = this.getHigherKey(this.position, nextTime);
                double lastControlTime = this.getLowerKey(this.position, lastTime);
                PositionKeyframe nextControlVector = this.position.get(nextControlTime);
                PositionKeyframe lastControlVector = this.position.get(lastControlTime);
                return TMath.smoothLerp((Vector)lastControlVector.getValue(), (Vector)lastVector.getValue(), (Vector)nextVector.getValue(), (Vector)nextControlVector.getValue(), t);
            }
            case STEP: {
                return ((Vector)lastVector.getValue()).clone();
            }
        }
        return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
    }

    public EulerAngle getRotationFrame(double time) {
        double lastTime;
        if (this.rotation.isEmpty()) {
            return EulerAngle.ZERO;
        }
        if (this.rotation.containsKey(time)) {
            return (EulerAngle)this.rotation.get(time).getValue();
        }
        double nextTime = this.getHigherKey(this.rotation, time);
        if (nextTime == (lastTime = this.getLowerKey(this.rotation, time))) {
            return (EulerAngle)this.rotation.get(lastTime).getValue();
        }
        double t = (time - lastTime) / (nextTime - lastTime);
        RotationKeyframe nextAngle = this.rotation.get(nextTime);
        RotationKeyframe lastAngle = this.rotation.get(lastTime);
        switch (this.getType(lastAngle, nextAngle)) {
            case LINEAR: {
                return TMath.lerp((EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), t);
            }
            case SMOOTH: {
                double nextControlTime = this.getHigherKey(this.rotation, nextTime);
                double lastControlTime = this.getLowerKey(this.rotation, lastTime);
                RotationKeyframe nextControlAngle = this.rotation.get(nextControlTime);
                RotationKeyframe lastControlAngle = this.rotation.get(lastControlTime);
                return TMath.smoothLerp((EulerAngle)lastControlAngle.getValue(), (EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), (EulerAngle)nextControlAngle.getValue(), t);
            }
            case STEP: {
                return (EulerAngle)lastAngle.getValue();
            }
        }
        return TMath.lerp((EulerAngle)lastAngle.getValue(), (EulerAngle)nextAngle.getValue(), t);
    }

    public Vector getScaleFrame(double time) {
        double lastTime;
        if (this.scale.isEmpty()) {
            return new Vector();
        }
        if (this.scale.containsKey(time)) {
            return ((Vector)this.scale.get(time).getValue()).clone();
        }
        double nextTime = this.getHigherKey(this.scale, time);
        if (nextTime == (lastTime = this.getLowerKey(this.scale, time))) {
            return ((Vector)this.scale.get(lastTime).getValue()).clone();
        }
        double t = (time - lastTime) / (nextTime - lastTime);
        ScaleKeyframe nextVector = this.scale.get(nextTime);
        ScaleKeyframe lastVector = this.scale.get(lastTime);
        switch (this.getType(lastVector, nextVector)) {
            case LINEAR: {
                return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
            }
            case SMOOTH: {
                double nextControlTime = this.getHigherKey(this.scale, nextTime);
                double lastControlTime = this.getLowerKey(this.scale, lastTime);
                ScaleKeyframe nextControlVector = this.scale.get(nextControlTime);
                ScaleKeyframe lastControlVector = this.scale.get(lastControlTime);
                return TMath.smoothLerp((Vector)lastControlVector.getValue(), (Vector)lastVector.getValue(), (Vector)nextVector.getValue(), (Vector)nextControlVector.getValue(), t);
            }
            case STEP: {
                return ((Vector)lastVector.getValue()).clone();
            }
        }
        return TMath.lerp((Vector)lastVector.getValue(), (Vector)nextVector.getValue(), t);
    }

    public List<ParticleKeyframe.Particles> getParticlesFrame(double time) {
        if (this.particle.isEmpty()) {
            return null;
        }
        if (this.particle.containsKey(time)) {
            return (List)this.particle.get(time).getValue();
        }
        double nextTime = this.getHigherKey(this.particle, time);
        double lastTime = this.getLowerKey(this.particle, time);
        if (Math.abs(time - lastTime) < 0.025) {
            return (List)this.particle.get(lastTime).getValue();
        }
        if (Math.abs(nextTime - time) < 0.025) {
            return (List)this.particle.get(nextTime).getValue();
        }
        return null;
    }

    public List<SoundKeyframe.Sounds> getSoundsFrame(double time) {
        if (this.sound.isEmpty()) {
            return null;
        }
        if (this.sound.containsKey(time)) {
            return (List)this.sound.get(time).getValue();
        }
        double nextTime = this.getHigherKey(this.sound, time);
        double lastTime = this.getLowerKey(this.sound, time);
        if (Math.abs(time - lastTime) < 0.025) {
            return (List)this.sound.get(lastTime).getValue();
        }
        if (Math.abs(nextTime - time) < 0.025) {
            return (List)this.sound.get(nextTime).getValue();
        }
        return null;
    }

    public List<ScriptKeyframe.Script> getScriptFrame(double time) {
        if (this.script.isEmpty()) {
            return null;
        }
        if (this.script.containsKey(time)) {
            return (List)this.script.get(time).getValue();
        }
        double nextTime = this.getHigherKey(this.script, time);
        double lastTime = this.getLowerKey(this.script, time);
        if (Math.abs(time - lastTime) < 0.025) {
            return (List)this.script.get(lastTime).getValue();
        }
        if (Math.abs(nextTime - time) < 0.025) {
            return (List)this.script.get(nextTime).getValue();
        }
        return null;
    }

    private double getHigherKey(TreeMap<Double, ?> map, double time) {
        Double high = map.higherKey(time);
        if (high == null) {
            return map.lastKey();
        }
        return high;
    }

    private double getLowerKey(TreeMap<Double, ?> map, double time) {
        Double low = map.lowerKey(time);
        if (low == null) {
            return map.firstKey();
        }
        return low;
    }

    private KeyframeType getType(AbstractKeyframe<?> last, AbstractKeyframe<?> next) {
        if (last.getType() == KeyframeType.STEP) {
            return KeyframeType.STEP;
        }
        if (last.getType() == KeyframeType.SMOOTH || next.getType() == KeyframeType.SMOOTH) {
            return KeyframeType.SMOOTH;
        }
        return KeyframeType.LINEAR;
    }
}

