/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.state;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.animation.AnimationProperty;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import java.util.Map;

public class DefaultStateHandler {
    private final ActiveModel model;
    private final Map<ModelState, Property> properties = Maps.newConcurrentMap();

    public DefaultStateHandler(ActiveModel model) {
        this.model = model;
        this.properties.put(ModelState.IDLE, new Property(ModelState.IDLE.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.WALK, new Property(ModelState.WALK.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.JUMP, new Property(ModelState.JUMP.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.SPAWN, new Property(ModelState.SPAWN.getString(), 0.0, 0.25, 1.0));
        this.properties.put(ModelState.DEATH, new Property(ModelState.DEATH.getString(), 0.25, 0.0, 1.0));
    }

    public void setProperty(ModelState state, Property property) {
        this.properties.put(state, property);
    }

    public Property getProperty(ModelState state) {
        return this.properties.get(state);
    }

    public ActiveModel getModel() {
        return this.model;
    }

    public static class Property {
        private final String animation;
        private final double lerpIn;
        private final double lerpOut;
        private final double speed;

        public AnimationProperty build(ModelBlueprint blueprint) {
            BlueprintAnimation blueprintAnimation = blueprint.getAnimations().get(this.animation);
            if (blueprintAnimation == null) {
                return null;
            }
            return new AnimationProperty(blueprintAnimation, this.lerpIn, this.lerpOut, this.speed);
        }

        public Property(String animation, double lerpIn, double lerpOut, double speed) {
            this.animation = animation;
            this.lerpIn = lerpIn;
            this.lerpOut = lerpOut;
            this.speed = speed;
        }

        public String getAnimation() {
            return this.animation;
        }

        public double getLerpIn() {
            return this.lerpIn;
        }

        public double getLerpOut() {
            return this.lerpOut;
        }

        public double getSpeed() {
            return this.speed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLerpIn(), other.getLerpIn()) != 0) {
                return false;
            }
            if (Double.compare(this.getLerpOut(), other.getLerpOut()) != 0) {
                return false;
            }
            if (Double.compare(this.getSpeed(), other.getSpeed()) != 0) {
                return false;
            }
            String this$animation = this.getAnimation();
            String other$animation = other.getAnimation();
            return !(this$animation == null ? other$animation != null : !this$animation.equals(other$animation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lerpIn = Double.doubleToLongBits(this.getLerpIn());
            result = result * 59 + (int)($lerpIn >>> 32 ^ $lerpIn);
            long $lerpOut = Double.doubleToLongBits(this.getLerpOut());
            result = result * 59 + (int)($lerpOut >>> 32 ^ $lerpOut);
            long $speed = Double.doubleToLongBits(this.getSpeed());
            result = result * 59 + (int)($speed >>> 32 ^ $speed);
            String $animation = this.getAnimation();
            result = result * 59 + ($animation == null ? 43 : $animation.hashCode());
            return result;
        }

        public String toString() {
            return "DefaultStateHandler.Property(animation=" + this.getAnimation() + ", lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", speed=" + this.getSpeed() + ")";
        }
    }
}

