/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.blueprint;

import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.timeline.Timeline;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlueprintAnimation {
    private final Map<String, Timeline> timelines = new HashMap<String, Timeline>();
    private final String name;
    private double length;
    private LoopMode loopMode;
    private boolean override;

    public BlueprintAnimation(String name) {
        this.name = name;
    }

    public Timeline getOrCreateTimeline(String bone) {
        if (this.timelines.containsKey(bone)) {
            return this.timelines.get(bone);
        }
        Timeline timeline = new Timeline();
        this.timelines.put(bone, timeline);
        return timeline;
    }

    @Nullable
    public Vector getPosition(String bone, double time) {
        if (!this.timelines.containsKey(bone)) {
            return null;
        }
        return this.timelines.get(bone).getPositionFrame(time);
    }

    @NotNull
    public Vector getPositionOrZero(String bone, double time) {
        Vector pos = this.getPosition(bone, time);
        if (pos == null) {
            pos = new Vector(0, 0, 0);
        }
        return pos;
    }

    @Nullable
    public EulerAngle getRotation(String bone, double time) {
        if (!this.timelines.containsKey(bone)) {
            return null;
        }
        return this.timelines.get(bone).getRotationFrame(time);
    }

    @NotNull
    public EulerAngle getRotationOrZero(String bone, double time) {
        EulerAngle rot = this.getRotation(bone, time);
        if (rot == null) {
            rot = TMath.makeAngle(0.0, 0.0, 0.0);
        }
        return rot;
    }

    public Vector getScale(String bone, double time) {
        if (!this.timelines.containsKey(bone)) {
            return new Vector(1, 1, 1);
        }
        return this.timelines.get(bone).getScaleFrame(time);
    }

    public List<ScriptKeyframe.Script> getScripts(double time) {
        if (!this.timelines.containsKey("effects")) {
            return null;
        }
        return this.timelines.get("effects").getScriptFrame(time);
    }

    public String getName() {
        return this.name;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

