/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation;

import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.keyframe.ScriptKeyframe;
import java.util.List;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class AnimationProperty {
    private final BlueprintAnimation blueprintAnimation;
    private final double lerpIn;
    private final double lerpOut;
    private double lerpInTime = 0.0;
    private double lerpOutTime = 0.0;
    private double time = 0.0;
    private double speed;
    private Phase phase = Phase.LERPIN;
    private LoopMode forceLoopMode = null;
    private boolean forceOverride = false;

    public AnimationProperty(BlueprintAnimation blueprintAnimation) {
        this(blueprintAnimation, 0.0, 0.0, 1.0);
    }

    public AnimationProperty(BlueprintAnimation blueprintAnimation, double lerpIn, double lerpOut, double speed) {
        this.blueprintAnimation = blueprintAnimation;
        this.lerpIn = lerpIn;
        this.lerpOut = lerpOut;
        this.speed = speed;
    }

    public boolean update() {
        return switch (this.phase) {
            default -> throw new IncompatibleClassChangeError();
            case Phase.LERPIN -> this.updateLerpIn();
            case Phase.PLAY -> this.updateTime();
            case Phase.LERPOUT -> this.updateLerpOut();
        };
    }

    private boolean updateLerpIn() {
        if (this.lerpInTime >= this.lerpIn - 1.0E-5) {
            return this.updateTime();
        }
        this.lerpInTime += this.speed / 20.0;
        return true;
    }

    private boolean updateTime() {
        if (this.phase == Phase.LERPIN) {
            this.phase = Phase.PLAY;
            return true;
        }
        LoopMode mode = this.forceLoopMode == null ? this.blueprintAnimation.getLoopMode() : this.forceLoopMode;
        switch (mode) {
            case ONCE: {
                if (this.time < this.blueprintAnimation.getLength()) {
                    this.time = Math.min(this.time + this.speed / 20.0, this.blueprintAnimation.getLength());
                    return true;
                }
                return this.updateLerpOut();
            }
            case HOLD: {
                this.time = Math.min(this.time + this.speed / 20.0, this.blueprintAnimation.getLength());
                return true;
            }
            case LOOP: {
                this.time = (this.time + this.speed / 20.0) % (this.blueprintAnimation.getLength() + 0.05);
                return true;
            }
        }
        return false;
    }

    private boolean updateLerpOut() {
        if (this.phase == Phase.PLAY && this.lerpOut > 1.0E-5) {
            this.phase = Phase.LERPOUT;
            return true;
        }
        if (this.lerpOutTime >= this.lerpOut - 1.0E-5) {
            return false;
        }
        this.lerpOutTime += this.speed / 20.0;
        return true;
    }

    public void stop() {
        this.phase = Phase.LERPOUT;
    }

    public Vector getPositionFrame(String bone) {
        return this.blueprintAnimation.getPosition(bone, this.time);
    }

    public EulerAngle getRotationFrame(String bone) {
        return this.blueprintAnimation.getRotation(bone, this.time);
    }

    public List<ScriptKeyframe.Script> getScriptFrame() {
        return this.blueprintAnimation.getScripts(this.time);
    }

    public double getLerpInRatio() {
        return this.lerpInTime / this.lerpIn;
    }

    public double getLerpOutRatio() {
        return this.lerpOutTime / this.lerpOut;
    }

    public boolean isFinished() {
        return this.phase == Phase.LERPOUT || this.time >= this.blueprintAnimation.getLength();
    }

    public String toString() {
        return "AnimationProperty{blueprintAnimation=" + this.blueprintAnimation + ", lerpIn=" + this.lerpIn + ", lerpOut=" + this.lerpOut + ", lerpInTime=" + this.lerpInTime + ", lerpOutTime=" + this.lerpOutTime + ", time=" + this.time + ", speed=" + this.speed + ", phase=" + this.phase + ", forceLoopMode=" + this.forceLoopMode + ", forceOverride=" + this.forceOverride + "}";
    }

    public BlueprintAnimation getBlueprintAnimation() {
        return this.blueprintAnimation;
    }

    public double getLerpIn() {
        return this.lerpIn;
    }

    public double getLerpOut() {
        return this.lerpOut;
    }

    public double getLerpInTime() {
        return this.lerpInTime;
    }

    public void setLerpInTime(double lerpInTime) {
        this.lerpInTime = lerpInTime;
    }

    public double getLerpOutTime() {
        return this.lerpOutTime;
    }

    public void setLerpOutTime(double lerpOutTime) {
        this.lerpOutTime = lerpOutTime;
    }

    public double getTime() {
        return this.time;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(double speed) {
        this.speed = speed;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public LoopMode getForceLoopMode() {
        return this.forceLoopMode;
    }

    public void setForceLoopMode(LoopMode forceLoopMode) {
        this.forceLoopMode = forceLoopMode;
    }

    public boolean isForceOverride() {
        return this.forceOverride;
    }

    public void setForceOverride(boolean forceOverride) {
        this.forceOverride = forceOverride;
    }

    public static enum Phase {
        LERPIN,
        PLAY,
        LERPOUT;

    }
}

