/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api;

import com.google.gson.Gson;
import com.ticxo.modelengine.api.animation.script.ScriptReaderRegistry;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.BukkitEntity;
import com.ticxo.modelengine.api.entity.BukkitPlayer;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.reader.BoneReaderManager;
import com.ticxo.modelengine.api.model.mananger.InteractionTicker;
import com.ticxo.modelengine.api.model.mananger.ModelRegistry;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.MountControllerRegistry;
import com.ticxo.modelengine.api.mount.MountPairManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.NMSHandler;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.network.NetworkHandler;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.CompatibilityManager;
import com.ticxo.modelengine.api.utils.config.ConfigManager;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ModelEngineAPI
extends JavaPlugin {
    public static ModelEngineAPI api;
    public static final Gson gson;
    protected String minecraftVersion;
    protected int versionNumber;
    protected PluginManager pluginManager;
    protected CompatibilityManager compatibilityManager;
    protected ConfigManager configManager;
    protected ModelRegistry modelRegistry;
    protected ModelGenerator generator;
    protected BoneReaderManager boneReader;
    protected ModelTicker modelTicker;
    protected VFXTicker vfxTicker;
    protected MountControllerRegistry controllerRegistry;
    protected MountPairManager mountManager;
    protected ScriptReaderRegistry scriptReaderRegistry;
    protected NMSHandler nms;
    protected InteractionTicker interactionTicker;

    public static void callEvent(Event event) {
        api.getPluginManager().callEvent(event);
    }

    public static ConfigManager getConfigManager() {
        return ModelEngineAPI.api.configManager;
    }

    public static EntityHandler getEntityHandler() {
        return api.getNms().getEntityHandler();
    }

    public static WorldHandler getWorldHandler() {
        return api.getNms().getWorldHandler();
    }

    public static NetworkHandler getNetworkHandler() {
        return api.getNms().getNetworkHandler();
    }

    public static ModelTicker getModelTicker() {
        return ModelEngineAPI.api.modelTicker;
    }

    public static VFXTicker getVFXTicker() {
        return ModelEngineAPI.api.vfxTicker;
    }

    public static MountControllerRegistry getControllerRegistry() {
        return ModelEngineAPI.api.controllerRegistry;
    }

    public static MountPairManager getMountManager() {
        return ModelEngineAPI.api.mountManager;
    }

    public static ModeledEntity createModeledEntity(Entity base) {
        return ModelEngineAPI.createModeledEntity(new BukkitEntity(base));
    }

    public static ModeledEntity createModeledEntity(Player base) {
        return ModelEngineAPI.createModeledEntity(new BukkitPlayer(base));
    }

    public static ModeledEntity createModeledEntity(BaseEntity<?> base) {
        return api.createModeledEntityImpl(base);
    }

    public static ModeledEntity getModeledEntity(UUID uuid) {
        return ModelEngineAPI.getModelTicker().getModeledEntity(uuid);
    }

    public static ModeledEntity getOrCreateModeledEntity(Entity entity) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
        if (model != null) {
            return model;
        }
        return ModelEngineAPI.createModeledEntity(entity);
    }

    public static ActiveModel createActiveModel(String modelId) {
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(modelId);
        if (blueprint == null) {
            TLogger.warn("Unable to create ActiveModel instance: Invalid model ID " + modelId);
            return null;
        }
        return ModelEngineAPI.createActiveModel(blueprint);
    }

    public static ActiveModel createActiveModel(@NotNull ModelBlueprint blueprint) {
        return api.createActiveModelImpl(blueprint);
    }

    public static VFX createVFX(Entity entity) {
        return ModelEngineAPI.createVFX(new BukkitEntity(entity));
    }

    public static VFX createVFX(Player player) {
        return ModelEngineAPI.createVFX(new BukkitPlayer(player));
    }

    public static VFX createVFX(BaseEntity<?> entity) {
        return api.createVFXImpl(entity);
    }

    public static void registerModeledEntity(BaseEntity<?> base, ModeledEntity model) {
        ModelEngineAPI.getModelTicker().registerModeledEntity(base, model);
    }

    public static void removeModeledEntity(UUID uuid) {
        ModelEngineAPI.getModelTicker().removeModeledEntity(uuid);
    }

    public static boolean isModeledEntity(UUID uuid) {
        return ModelEngineAPI.getModelTicker().isModeledEntity(uuid);
    }

    public static ModelBlueprint getBlueprint(@NotNull String modelId) {
        return api.getModelRegistry().getBlueprint(modelId.toLowerCase(Locale.ENGLISH));
    }

    public static void registerMountedPair(Entity entity, ModeledEntity model, MountController controller) {
        ModelEngineAPI.api.mountManager.registerMountedPair(entity, model, controller);
    }

    public static void unregisterMountedPair(UUID uuid) {
        ModelEngineAPI.api.mountManager.unregisterMountedPair(uuid);
    }

    public static ModeledEntity getMountPair(UUID uuid) {
        return ModelEngineAPI.api.mountManager.getMountedPair(uuid);
    }

    public static MountController getPlayerMountController(UUID uuid) {
        return ModelEngineAPI.api.mountManager.getController(uuid);
    }

    public static Dummy createDummy() {
        return ModelEngineAPI.createDummy(UUID.randomUUID());
    }

    public static Dummy createDummy(UUID uuid) {
        return new Dummy(ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet(), uuid);
    }

    public abstract ModeledEntity createModeledEntityImpl(BaseEntity<?> var1);

    public abstract ActiveModel createActiveModelImpl(ModelBlueprint var1);

    public abstract VFX createVFXImpl(BaseEntity<?> var1);

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public ModelGenerator getGenerator() {
        return this.generator;
    }

    public BoneReaderManager getBoneReader() {
        return this.boneReader;
    }

    public ScriptReaderRegistry getScriptReaderRegistry() {
        return this.scriptReaderRegistry;
    }

    public NMSHandler getNms() {
        return this.nms;
    }

    public InteractionTicker getInteractionTicker() {
        return this.interactionTicker;
    }

    public void setMinecraftVersion(String minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    public void setVersionNumber(int versionNumber) {
        this.versionNumber = versionNumber;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setCompatibilityManager(CompatibilityManager compatibilityManager) {
        this.compatibilityManager = compatibilityManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setModelRegistry(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void setGenerator(ModelGenerator generator) {
        this.generator = generator;
    }

    public void setBoneReader(BoneReaderManager boneReader) {
        this.boneReader = boneReader;
    }

    public void setModelTicker(ModelTicker modelTicker) {
        this.modelTicker = modelTicker;
    }

    public void setVfxTicker(VFXTicker vfxTicker) {
        this.vfxTicker = vfxTicker;
    }

    public void setControllerRegistry(MountControllerRegistry controllerRegistry) {
        this.controllerRegistry = controllerRegistry;
    }

    public void setMountManager(MountPairManager mountManager) {
        this.mountManager = mountManager;
    }

    public void setScriptReaderRegistry(ScriptReaderRegistry scriptReaderRegistry) {
        this.scriptReaderRegistry = scriptReaderRegistry;
    }

    public void setNms(NMSHandler nms) {
        this.nms = nms;
    }

    public void setInteractionTicker(InteractionTicker interactionTicker) {
        this.interactionTicker = interactionTicker;
    }

    static {
        gson = new Gson();
    }
}

