/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.animation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.AnimationProperty;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.keyframe.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.script.ScriptReader;
import com.ticxo.modelengine.api.animation.script.ScriptReaderRegistry;
import com.ticxo.modelengine.api.events.AnimationEndEvent;
import com.ticxo.modelengine.api.events.AnimationPlayEvent;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PriorityHandler
implements AnimationHandler {
    private final ActiveModel model;
    private final Map<String, AnimationProperty> properties = Maps.newConcurrentMap();
    private final List<AnimationProperty> animations = new ArrayList<AnimationProperty>();
    private List<AnimationProperty> immutableAnimations;

    public PriorityHandler(ActiveModel model) {
        this.model = model;
    }

    @Override
    public void updateAll() {
        this.animations.clear();
        for (String animation : this.model.getBlueprint().getAnimations().keySet()) {
            if (!this.properties.containsKey(animation)) continue;
            AnimationProperty a = this.properties.get(animation);
            if (a != null && a.update()) {
                this.animations.add(a);
                continue;
            }
            ModelEngineAPI.callEvent(new AnimationEndEvent(this.model, a));
            this.properties.remove(animation);
        }
        try {
            this.immutableAnimations = ImmutableList.copyOf(this.animations);
        }
        catch (NullPointerException ignored) {
            this.immutableAnimations = ImmutableList.of();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.immutableAnimations = ImmutableList.of();
        }
    }

    @Override
    public void tickEffects() {
        ScriptReaderRegistry readerRegistry = ModelEngineAPI.api.getScriptReaderRegistry();
        for (AnimationProperty prop : this.getAnimations()) {
            List<ScriptKeyframe.Script> scripts;
            if (prop.getPhase() != AnimationProperty.Phase.PLAY || (scripts = prop.getScriptFrame()) == null) continue;
            for (ScriptKeyframe.Script script : scripts) {
                String reader = script.getReader();
                ScriptReader scriptReader = (ScriptReader)readerRegistry.get(reader);
                if (scriptReader == null) continue;
                scriptReader.read(this.model, script.getScript());
            }
        }
    }

    @Override
    public void forEachProperty(BiConsumer<String, AnimationProperty> consumer) {
        this.properties.forEach(consumer);
    }

    @Override
    public AnimationProperty getAnimation(String animation) {
        return this.properties.get(animation);
    }

    @Override
    public List<AnimationProperty> getAnimations() {
        return this.immutableAnimations;
    }

    @Override
    public Vector getFinalPosition(ModelBone bone) {
        Vector finalPos = new Vector();
        for (AnimationProperty prop : this.getAnimations()) {
            Vector vec = prop.getPositionFrame(bone.getBoneId());
            if (!prop.isForceOverride() && !prop.getBlueprintAnimation().isOverride()) {
                if (vec == null) {
                    vec = new Vector();
                }
                switch (prop.getPhase()) {
                    case LERPIN: {
                        vec = TMath.lerp(new Vector(), vec, prop.getLerpInRatio());
                        break;
                    }
                    case LERPOUT: {
                        vec = TMath.lerp(vec, new Vector(), prop.getLerpOutRatio());
                    }
                }
                finalPos.add(vec);
                continue;
            }
            if (vec == null) continue;
            switch (prop.getPhase()) {
                case LERPIN: {
                    finalPos = TMath.lerp(finalPos, vec, prop.getLerpInRatio());
                    break;
                }
                case PLAY: {
                    finalPos = vec;
                    break;
                }
                case LERPOUT: {
                    finalPos = TMath.lerp(vec, finalPos, prop.getLerpOutRatio());
                }
            }
        }
        BlueprintBone bBone = bone.getBlueprintBone();
        finalPos.add(bBone.getLocalOrigin());
        ModelBone parent = bone.getParent();
        if (parent != null) {
            Offset.getRelativeLocation(parent.getRotation(), finalPos);
            Offset.rotateYaw(finalPos, Math.toRadians(parent.getClientAproxYaw())).add(parent.getPosition());
        } else {
            ModeledEntity modeledEntity = bone.getActiveModel().getModeledEntity();
            Offset.rotateYaw(finalPos, Math.toRadians(modeledEntity.getBodyYaw())).add(modeledEntity.getLocation());
        }
        return finalPos;
    }

    @Override
    public EulerAngle getFinalRotation(ModelBone bone) {
        EulerAngle finalRot = EulerAngle.ZERO;
        for (AnimationProperty prop : this.getAnimations()) {
            EulerAngle angle = prop.getRotationFrame(bone.getBoneId());
            if (!prop.isForceOverride() && !prop.getBlueprintAnimation().isOverride()) {
                if (angle == null) {
                    angle = EulerAngle.ZERO;
                }
                switch (prop.getPhase()) {
                    case LERPIN: {
                        angle = TMath.lerp(EulerAngle.ZERO, angle, prop.getLerpInRatio());
                        break;
                    }
                    case LERPOUT: {
                        angle = TMath.lerp(angle, EulerAngle.ZERO, prop.getLerpOutRatio());
                    }
                }
                finalRot = TMath.add(finalRot, angle);
                continue;
            }
            if (angle == null) continue;
            switch (prop.getPhase()) {
                case LERPIN: {
                    if (angle.equals((Object)finalRot)) break;
                    finalRot = TMath.slerp(finalRot, angle, prop.getLerpInRatio());
                    break;
                }
                case PLAY: {
                    finalRot = angle;
                    break;
                }
                case LERPOUT: {
                    if (angle.equals((Object)finalRot)) break;
                    finalRot = TMath.slerp(angle, finalRot, prop.getLerpOutRatio());
                }
            }
        }
        ModelBone parent = bone.getParent();
        BlueprintBone bBone = bone.getBlueprintBone();
        if (parent != null) {
            EulerAngle parentRot = parent.getRotation();
            finalRot = TMath.localRotate(parentRot, TMath.add(finalRot, bBone.getLocalRotation()));
        } else {
            finalRot = TMath.add(finalRot, bBone.getLocalRotation());
        }
        if (!(parent != null && parent.isHead() || !bone.isHead() || bone.getActiveModel().isLockPitch())) {
            finalRot = TMath.globalRotate(finalRot, TMath.makeAngle(bone.getActiveModel().getModeledEntity().getHeadPitch(), 0.0, 0.0));
        }
        return finalRot;
    }

    @Override
    public boolean playAnimation(String animation, double lerpIn, double lerpOut, double speed, boolean force) {
        BlueprintAnimation blueprint = this.model.getBlueprint().getAnimations().get(animation);
        if (blueprint == null) {
            return false;
        }
        return this.playAnimation(new AnimationProperty(blueprint, lerpIn, lerpOut, speed), force);
    }

    @Override
    public boolean playAnimation(AnimationProperty property, boolean force) {
        AnimationPlayEvent event = new AnimationPlayEvent(this.model, property);
        ModelEngineAPI.callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        String name = property.getBlueprintAnimation().getName();
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, property);
            return true;
        }
        AnimationProperty old = this.properties.get(name);
        if (force || old.getPhase() == AnimationProperty.Phase.LERPOUT) {
            this.properties.put(name, property);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPlayingAnimation(String animation) {
        return this.properties.containsKey(animation);
    }

    @Override
    public void stopAnimation(String animation) {
        AnimationProperty a = this.properties.get(animation);
        if (a != null) {
            if (a.getLerpOut() > 1.0E-5) {
                a.stop();
            } else {
                this.forceStopAnimation(animation);
            }
        }
    }

    @Override
    public void forceStopAnimation(String animation) {
        this.properties.remove(animation);
    }

    @Override
    public void forceStopAllAnimations() {
        this.properties.clear();
    }

    @Override
    public ActiveModel getModel() {
        return this.model;
    }
}

