/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.animation;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.script.ScriptFunction;
import com.ticxo.modelengine.api.animation.script.ScriptReader;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.Nameable;
import com.ticxo.modelengine.api.model.handler.RendererHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.registry.TSingletonRegistry;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Color;

public class ModelEngineScriptReader
extends TSingletonRegistry<ScriptFunction>
implements ScriptReader {
    public ModelEngineScriptReader() {
        this.register("changeparent", this::changeParent);
        this.register("partvis", this::partVisibility);
        this.register("tint", this::tint);
        this.register("enchant", this::enchant);
        this.register("tag", this::tag);
        this.register("changepart", this::changePart);
        this.register("remap", this::remap);
    }

    @Override
    public void read(ActiveModel model, String script) {
        ScriptFunction function;
        ModelBlueprint blueprint = model.getBlueprint();
        ConcurrentMap map = Maps.newConcurrentMap();
        String[] scriptSplit = script.split("\\{", 2);
        String name = scriptSplit[0].toLowerCase(Locale.ENGLISH);
        if (scriptSplit.length == 2) {
            String[] parameters;
            for (String param : parameters = scriptSplit[1].substring(0, scriptSplit[1].length() - 1).split(";")) {
                String[] entry = param.split("=", 2);
                map.put(entry[0].strip(), entry.length == 2 ? this.getAnimationPlaceholder(blueprint, entry[1].strip()) : "");
            }
        }
        if ((function = (ScriptFunction)this.get(name)) != null) {
            function.call(model, map);
        } else {
            TLogger.warn("Unknown Model Engine script: " + script);
        }
    }

    private void changeParent(ActiveModel model, Map<String, String> param) {
        String parentPart = param.get("parent");
        String childPart = param.get("child");
        Map<String, ModelBone> index = model.getBoneIndex();
        ModelBone parent = index.get(parentPart);
        ModelBone child = index.get(childPart);
        if (parent != null && child != null) {
            parent.addChild(child);
        }
    }

    private void partVisibility(ActiveModel model, Map<String, String> param) {
        String part = param.get("part");
        boolean visible = Boolean.parseBoolean(param.get("visible"));
        boolean exact = Boolean.parseBoolean(param.get("exact"));
        Map renderers = model.getRendererHandler().getFakeEntity();
        if (exact) {
            if (renderers.containsKey(part)) {
                ((BoneRenderer)renderers.get(part)).setModelVisible(visible);
            }
        } else {
            for (String boneId : renderers.keySet()) {
                if (!boneId.contains(part)) continue;
                ((BoneRenderer)renderers.get(part)).setModelVisible(visible);
            }
        }
    }

    private void tint(ActiveModel model, Map<String, String> param) {
        String part = param.get("part");
        String colorString = param.get("color");
        if (colorString.startsWith("#")) {
            colorString = colorString.substring(1);
        }
        Color color = Color.fromRGB((int)Integer.parseInt(colorString, 16));
        boolean exact = Boolean.parseBoolean(param.get("exact"));
        Map renderers = model.getRendererHandler().getFakeEntity();
        if (exact) {
            if (renderers.containsKey(part)) {
                ((BoneRenderer)renderers.get(part)).setColor(color);
            }
        } else {
            for (String boneId : renderers.keySet()) {
                if (!boneId.contains(part)) continue;
                ((BoneRenderer)renderers.get(boneId)).setColor(color);
            }
        }
    }

    private void enchant(ActiveModel model, Map<String, String> param) {
        String part = param.get("part");
        boolean enchant = Boolean.parseBoolean(param.get("enchant"));
        boolean exact = Boolean.parseBoolean(param.get("exact"));
        Map renderers = model.getRendererHandler().getFakeEntity();
        if (exact) {
            if (renderers.containsKey(part)) {
                ((BoneRenderer)renderers.get(part)).setEnchant(enchant);
            }
        } else {
            for (String boneId : renderers.keySet()) {
                if (!boneId.contains(part)) continue;
                ((BoneRenderer)renderers.get(boneId)).setEnchant(enchant);
            }
        }
    }

    private void tag(ActiveModel model, Map<String, String> param) {
        String part = param.get("part");
        String tag = param.get("tag");
        boolean visible = Boolean.parseBoolean(param.getOrDefault("visible", "true"));
        Nameable bone = (Nameable)model.getNametagHandler().getBones().get(part);
        if (bone == null) {
            return;
        }
        if (tag != null) {
            bone.setCustomName(tag);
        }
        bone.setCustomNameVisible(visible);
    }

    private void changePart(ActiveModel model, Map<String, String> param) {
        ModelBlueprint blueprint;
        String part = param.get("part");
        String nModel = param.get("nmodel");
        String nPart = param.get("npart");
        BoneRenderer renderer = (BoneRenderer)model.getRendererHandler().getFakeEntity().get(part);
        if (renderer == null) {
            return;
        }
        ModelBlueprint modelBlueprint = blueprint = nModel != null ? ModelEngineAPI.getBlueprint(nModel) : model.getBlueprint();
        if (blueprint == null) {
            return;
        }
        Integer data = blueprint.getItemIds().get(nPart);
        if (data == null) {
            return;
        }
        renderer.setData(data);
    }

    private void remap(ActiveModel model, Map<String, String> param) {
        String nModel = param.get("model");
        String map = param.get("map");
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(nModel);
        if (blueprint == null) {
            return;
        }
        if (map != null) {
            ModelBlueprint mapBlueprint = ModelEngineAPI.getBlueprint(map);
            if (mapBlueprint == null) {
                return;
            }
            RendererHandler rendererHandler = model.getRendererHandler();
            Set<String> bones = mapBlueprint.getFlatMap().size() < rendererHandler.getFakeEntity().size() ? mapBlueprint.getFlatMap().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String bone : bones) {
                BoneRenderer renderer;
                Integer data = blueprint.getItemIds().get(bone);
                if (data == null || (renderer = (BoneRenderer)rendererHandler.getFakeEntity().get(bone)) == null) continue;
                renderer.setData(data);
            }
        } else {
            RendererHandler rendererHandler = model.getRendererHandler();
            Set<String> bones = blueprint.getItemIds().size() < rendererHandler.getFakeEntity().size() ? blueprint.getItemIds().keySet() : rendererHandler.getFakeEntity().keySet();
            for (String bone : bones) {
                BoneRenderer renderer;
                Integer data = blueprint.getItemIds().get(bone);
                if (data == null || (renderer = (BoneRenderer)rendererHandler.getFakeEntity().get(bone)) == null) continue;
                renderer.setData(data);
            }
        }
    }

    private String getAnimationPlaceholder(ModelBlueprint blueprint, String placeholder) {
        if (!placeholder.startsWith("<") || !placeholder.endsWith(">")) {
            return placeholder;
        }
        String key = placeholder.substring(1, placeholder.length() - 1);
        return blueprint.getAnimationsPlaceholders().getOrDefault(key, placeholder);
    }
}

