/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine;

import com.ticxo.modelengine.animation.ModelEngineScriptReader;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.script.ScriptReaderRegistry;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.command.AbstractCommand;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.reader.BoneReaderManager;
import com.ticxo.modelengine.api.model.mananger.InteractionTicker;
import com.ticxo.modelengine.api.model.mananger.ModelRegistry;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.MountControllerRegistry;
import com.ticxo.modelengine.api.mount.MountPairManager;
import com.ticxo.modelengine.api.mount.controller.flying.FlyingMountController;
import com.ticxo.modelengine.api.mount.controller.flying.FlyingMountController_v16;
import com.ticxo.modelengine.api.mount.controller.flying.FlyingMountForcedController;
import com.ticxo.modelengine.api.mount.controller.walking.WalkingMountController;
import com.ticxo.modelengine.api.mount.controller.walking.WalkingMountForcedController;
import com.ticxo.modelengine.api.utils.CompatibilityManager;
import com.ticxo.modelengine.api.utils.config.ConfigManager;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import com.ticxo.modelengine.api.utils.config.Property;
import com.ticxo.modelengine.api.utils.data.EntityData;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.citizens.CitizensCommand;
import com.ticxo.modelengine.citizens.ModelTrait;
import com.ticxo.modelengine.command.MECommand;
import com.ticxo.modelengine.generator.ModelGeneratorImpl;
import com.ticxo.modelengine.generator.parser.blockbench.BlockbenchParser;
import com.ticxo.modelengine.listener.EntityListener;
import com.ticxo.modelengine.listener.PlayerListener;
import com.ticxo.modelengine.listener.WorldListener;
import com.ticxo.modelengine.listener_v17.WorldListener_v17;
import com.ticxo.modelengine.model.ActiveModelImpl;
import com.ticxo.modelengine.model.ModeledEntityImpl;
import com.ticxo.modelengine.model.bone.BasicBone;
import com.ticxo.modelengine.model.bone.reader.BasicBoneReader;
import com.ticxo.modelengine.model.bone.reader.DriverBoneReader;
import com.ticxo.modelengine.model.bone.reader.HandBoneReader;
import com.ticxo.modelengine.model.bone.reader.LeashBoneReader;
import com.ticxo.modelengine.model.bone.reader.NametagBoneReader;
import com.ticxo.modelengine.model.bone.reader.PassengerBoneReader;
import com.ticxo.modelengine.model.bone.reader.RendererBoneReader;
import com.ticxo.modelengine.model.bone.reader.SegmentBoneReader;
import com.ticxo.modelengine.model.bone.reader.SubHitboxBoneReader;
import com.ticxo.modelengine.mythic.MythicListener;
import com.ticxo.modelengine.mythic.animation.MythicScriptReader;
import com.ticxo.modelengine.mythic.compatibility.ModelEngineSupportImpl;
import com.ticxo.modelengine.nms.v1_16_R3.NMSHandler_v1_16_R3;
import com.ticxo.modelengine.nms.v1_17_R1.NMSHandler_v1_17_R1;
import com.ticxo.modelengine.nms.v1_18_R1.NMSHandler_v1_18_R1;
import com.ticxo.modelengine.nms.v1_18_R2.NMSHandler_v1_18_R2;
import com.ticxo.modelengine.nms.v1_19_0_R1.NMSHandler_v1_19_0_R1;
import com.ticxo.modelengine.nms.v1_19_1_R1.NMSHandler_v1_19_1_R1;
import com.ticxo.modelengine.vfx.VFXImpl;
import io.lumine.mythic.bukkit.MythicBukkit;
import java.util.Optional;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ModelEngine
extends ModelEngineAPI {
    public static ModelEngine core;
    private AbstractCommand commandRoot;
    private ModelEngineSupportImpl mythicSupport;

    public void onLoad() {
        api = this;
        core = this;
        this.pluginManager = Bukkit.getPluginManager();
        EntityData.DATA_KEY = new NamespacedKey((Plugin)this, "model_data");
    }

    public void onEnable() {
        this.configureConfig();
        this.setModelRegistry(new ModelRegistry());
        this.configureGenerator();
        this.configureModelTicker();
        this.configureBoneReader();
        this.configureControllerRegistry();
        this.setMountManager(new MountPairManager());
        this.configureScriptReaderRegistry();
        this.configureNMSHandler();
        this.configureInteractionTicker();
        this.setupCommands();
        this.setCompatibilityManager(new CompatibilityManager(this));
        this.compatibilityManager.registerSupport("MythicMobs", this::configureMythicMobsSupport);
        this.compatibilityManager.registerSupport("Citizens", this::configureCitizensSupport);
        this.pluginManager.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.setupWorldListener();
        this.getGenerator().importModelsAsync();
    }

    public void onDisable() {
        ModelEngine.getModelTicker().saveAllModels();
    }

    @Override
    public ModeledEntity createModeledEntityImpl(BaseEntity<?> base) {
        return new ModeledEntityImpl(base);
    }

    @Override
    public ActiveModel createActiveModelImpl(ModelBlueprint blueprint) {
        return new ActiveModelImpl(blueprint);
    }

    @Override
    public VFX createVFXImpl(BaseEntity<?> base) {
        return new VFXImpl(base);
    }

    private void configureConfig() {
        this.setConfigManager(new ConfigManager(this));
        for (ConfigProperty configProperty : ConfigProperty.values()) {
            this.configManager.register(configProperty);
        }
        for (Enum enum_ : ModelState.values()) {
            this.configManager.register((Property)((Object)enum_));
        }
        this.configManager.save();
        this.configManager.registerReferenceUpdate(TMath::updateConfigs);
        this.configManager.registerReferenceUpdate(ActiveModelImpl::updateConfigs);
        this.configManager.registerReferenceUpdate(BasicBone::updateConfigs);
    }

    private void configureGenerator() {
        ModelGeneratorImpl generator = new ModelGeneratorImpl();
        generator.registerModelParser(new BlockbenchParser(generator));
        this.setGenerator(generator);
    }

    private void configureModelTicker() {
        this.setModelTicker(new ModelTicker(this));
        this.setVfxTicker(new VFXTicker(this));
        ModelEngine.getModelTicker().start();
        ModelEngine.getVFXTicker().start();
    }

    private void configureBoneReader() {
        this.setBoneReader(new BoneReaderManager());
        this.boneReader.registerReader(new SegmentBoneReader());
        this.boneReader.registerReader(new RendererBoneReader());
        this.boneReader.registerReader(new DriverBoneReader());
        this.boneReader.registerReader(new PassengerBoneReader());
        this.boneReader.registerReader(new HandBoneReader());
        this.boneReader.registerReader(new LeashBoneReader());
        this.boneReader.registerReader(new NametagBoneReader());
        this.boneReader.registerReader(new SubHitboxBoneReader());
        this.boneReader.setDefaultReader(new BasicBoneReader());
    }

    private void configureControllerRegistry() {
        this.setControllerRegistry(new MountControllerRegistry());
        this.controllerRegistry.registerAndDefault("walking", WalkingMountController::new);
        this.controllerRegistry.register("force_walking", WalkingMountForcedController::new);
        this.controllerRegistry.register("flying", FlyingMountController::new);
        this.controllerRegistry.register("flying_v16", FlyingMountController_v16::new);
        this.controllerRegistry.register("force_flying", FlyingMountForcedController::new);
    }

    private void configureScriptReaderRegistry() {
        this.setScriptReaderRegistry(new ScriptReaderRegistry());
        this.scriptReaderRegistry.registerAndDefault("meg", new ModelEngineScriptReader());
    }

    private void configureNMSHandler() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        this.minecraftVersion = name.substring(name.lastIndexOf(46) + 1);
        this.versionNumber = Integer.parseInt(this.minecraftVersion.split("_")[1]);
        switch (this.minecraftVersion) {
            case "v1_16_R3": {
                this.setNms(new NMSHandler_v1_16_R3());
                break;
            }
            case "v1_17_R1": {
                this.setNms(new NMSHandler_v1_17_R1());
                break;
            }
            case "v1_18_R1": {
                this.setNms(new NMSHandler_v1_18_R1());
                break;
            }
            case "v1_18_R2": {
                this.setNms(new NMSHandler_v1_18_R2());
                break;
            }
            case "v1_19_R1": {
                if ("1.19-R0.1-SNAPSHOT".equals(Bukkit.getBukkitVersion())) {
                    this.setNms(new NMSHandler_v1_19_0_R1());
                    break;
                }
                this.setNms(new NMSHandler_v1_19_1_R1());
            }
        }
    }

    private void configureInteractionTicker() {
        this.setInteractionTicker(new InteractionTicker(this));
        this.getInteractionTicker().start();
    }

    private void setupCommands() {
        PluginCommand command = this.getCommand("meg");
        if (command != null) {
            this.commandRoot = new MECommand(this);
            command.setExecutor((CommandExecutor)this.commandRoot);
        }
    }

    private void setupWorldListener() {
        if (this.versionNumber >= 18) {
            this.pluginManager.registerEvents((Listener)new WorldListener_v17(), (Plugin)this);
        } else {
            this.pluginManager.registerEvents((Listener)new WorldListener(), (Plugin)this);
        }
    }

    private boolean configureMythicMobsSupport(Plugin plugin) {
        this.pluginManager.registerEvents((Listener)new MythicListener(), (Plugin)this);
        this.scriptReaderRegistry.register("mm", new MythicScriptReader());
        this.mythicSupport = new ModelEngineSupportImpl();
        MythicBukkit.inst().getCompatibility().setModelEngine(Optional.of(this.mythicSupport));
        return true;
    }

    private boolean configureCitizensSupport(Plugin plugin) {
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(ModelTrait.class));
        this.commandRoot.addSubCommands(new CitizensCommand(this.commandRoot));
        return true;
    }

    public ModelEngineSupportImpl getMythicSupport() {
        return this.mythicSupport;
    }
}

