function setHeaders() {
    document.getElementById("Home").title = "Home";
    document.getElementById("Quests").title = "Quests";
    document.getElementById("Tree").title = "Tree";
    document.getElementById("Kills").title = "Kills";
}

function addHead(tr, text) {
    let th = document.createElement("th");
    th.textContent = text;
    tr.appendChild(th);
    return th;
}

function removeCodes(text) {
    while (text.toString().includes("&") && (text.toString().indexOf("&") !== text.toString().length - 1)) {
        let start = text.toString().substring(0, text.toString().indexOf(`&`));
        let end = text.toString().substring(text.toString().indexOf(`&`) + 2);
        text = start + end;
    }
    return text;
}

function countOccurrences(str, value) {
    let regExp = new RegExp(value, "gi");
    return (str.match(regExp) || []).length;
}

function addRanksOP(result) {
    let codes = ["&4", "&c", "&6", "&e", "&2", "&a", "&b", "&3", "&1", "&9", "&d", "&5", "&f", "&7", "&8", "&0", "&l", "&m", "&n", "&o"];
    $(document).ready(async function () {
        $('#ranks').DataTable({
            data: JSON.parse(await result.text()),
            dom: '<"toolbar">lfrtip',
            scrollX: true,
            columns: [
                {
                    data: 'rankName',
                    render: function (data) {
                        let count = countOccurrences(data.toString(), `&`);
                        for (let i = 0; i < count; i++) {
                            let contain = false;
                            codes.some(element => {
                                if (data.includes(element)) {
                                    contain = true;
                                }
                            });
                            if (contain) {
                                data = replaceColorCodes(data.toString().trim());
                            }
                            //console.log(item);
                        }
                        return data;
                    }
                },
                {data: 'rankID'},
                {data: 'material'},
                {data: 'luckPermGroup'},
                {data: 'prefix'},
                {data: 'suffix.'},
                {
                    data: 'requiredRank',//Required Rank ID
                    render: function (data) {
                        return data.toString().toLowerCase().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'requiredRankNames',
                    render: function (data) {
                        return data.toString().toLowerCase().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'mcMMO',
                    render: function (data) {
                        return data.toString().replaceAll(/:/g, ": ").replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'cost',
                    render: function (data) {
                        return data.toString().replaceAll(/:/g, ": ").replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'pathNames',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'path',//Path ID
                    render: function (data) {
                        return data.toString().toLowerCase().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'jobsReborn',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'kills',
                    render: function (data) {
                        return data.toString().replaceAll(/MC:/g, "").replaceAll(/:/g, " : ").replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'commands',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                }
            ],
            columnDefs: [{
                targets: 9,
                className: 'text-nowrap'
            },{
                targets: 14,
                className: 'text-nowrap'
            }]
        });
        $('div.toolbar').html('<b>Player Ranks</b>');
    });
}

function addRanks(response) {
    let codes = ["&4", "&c", "&6", "&e", "&2", "&a", "&b", "&3", "&1", "&9", "&d", "&5", "&f", "&7", "&8", "&0", "&l", "&m", "&n", "&o"];
    $(document).ready(async function () {
        $('#ranks').DataTable({
            dom: '<"toolbar">lfrtip',
            scrollX: true,
            data: JSON.parse(await response.text()),
            columns: [
                {
                    data: 'rankName',
                    render: function (data) {
                        let count = countOccurrences(data.toString(), `&`);
                        for (let i = 0; i < count; i++) {
                            let contain = false;
                            codes.some(element => {
                                if (data.includes(element)) {
                                    contain = true;
                                }
                            });
                            if (contain) {
                                data = replaceColorCodes(data.toString().trim());
                            }
                            //console.log(item);
                        }
                        return data;
                    }
                },
                {data: 'prefix'},
                {data: 'suffix.'},
                {
                    data: 'requiredRankNames',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'mcMMO',
                    render: function (data) {
                        return data.toString().replaceAll(/:/g, ": ").replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'cost',
                    render: function (data) {
                        return data.toString().replaceAll(/:/g, ": ").replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'pathNames',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'jobsReborn',
                    render: function (data) {
                        return data.toString().replaceAll(/,/g, "<br>");
                    }
                },
                {
                    data: 'kills',
                    render: function (data) {
                        return data.toString().replaceAll(/MC:/g, "").replaceAll(/:/g, " : ").replaceAll(/,/g, "<br>");
                    }
                }
            ],
            columnDefs: [{
                targets: 6,
                className: 'text-nowrap'
            }]
        });
        $('div.toolbar').html('<b>Player Ranks</b>');
    });
}