let maxTier;
let maxRow;
let playerRanks;
let allRanks;

function getTree() {
    return fetch('/api/tree/info').then(async (response) => {
        return await response.json().then(result => {
            return result;
        });
    }).catch(error => {
        console.log(error)
    });
}


function findPos(obj){
    let curLeft = obj.offsetWidth / 2;
    let curTop = obj.offsetHeight / 2;
    if (obj.offsetParent) {
        do {
            curLeft += obj.offsetLeft;
            curTop += obj.offsetTop;
        } while (obj === obj.offsetParent);
        return {x:curLeft,y:curTop};
    }
}


async function getRanks() {
    await fetch('/api/player/ranks/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async response => {
        const r = await response;
        const json = r.clone();
        if (await r.text() !== "Not a player") {
            await json.json().then(result => {
                playerRanks = result;
            });
        } else {
            playerRanks = "Player not found";
        }
    });
}

//Draw tree
window.addEventListener("DOMContentLoaded", async function () {
    await addButtons()
    await getTree().then(async ranks => {
        allRanks = ranks;
        let canvas = document.getElementById('canvas');
        canvas.width = (maxRow * 100);
        canvas.height = (maxTier * 100);
        drawLines(ranks, canvas);
    });
});

function drawLines(ranks, canvas) {
    let ctx = canvas.getContext('2d');
    if (ranks !== null && ranks !== undefined) {
        ranks.forEach((item) => {
            let path = item['path'];
            if (path !== null) {
                path.forEach((destination) => {
                    if (destination !== null) {
                        ctx.beginPath();
                        let pos = findPos(document.getElementById(item['rankID']));
                        let pos2 = findPos(document.getElementById(destination.toString().toLowerCase()));
                        canvas_arrow(ctx, pos.x, pos.y, pos2.x, pos2.y - 12);
                        if (localStorage.getItem(`darkmode`) === `true`) {
                            ctx.strokeStyle = '#FFFFFF';
                        } else {
                            ctx.strokeStyle = '#000000';
                        }
                        if (playerRanks !== "Player not found") {
                            playerRanks.forEach((item) => {
                                if ((item['rankID'].toString().toLowerCase() === destination.toString().toLowerCase())
                                    || (item['rankID'].toString() === "default")) {
                                    ctx.strokeStyle = '#FF0000';
                                    return false;
                                }
                            });
                        }
                        ctx.stroke();
                    }
                });
            }
        });
    }
}

function canvas_arrow(context, fromX, fromY, toX, toY) {
    let headLength = 10; // length of head in pixels
    let dx = toX - fromX;
    let dy = toY - fromY;
    let angle = Math.atan2(dy, dx);
    context.moveTo(fromX, fromY);
    context.lineTo(toX, toY);
    context.lineTo(toX - headLength * Math.cos(angle - Math.PI / 6),
        toY - headLength * Math.sin(angle - Math.PI / 6));
    context.moveTo(toX, toY);
    context.lineTo(toX - headLength * Math.cos(angle + Math.PI / 6),
        toY - headLength * Math.sin(angle + Math.PI / 6));
}

async function addButtons() {
    await fetch('/api/tree/info').then(async response => {
        await response.json().then(async result => {
            await getRanks();
            let i = 0;
            let j = 0;
            let temp = 0;
            await result.forEach(function (item) {
                j++;
                let section = document.getElementById("rankButtons");
                let element = document.createElement("button");
                if (i !== item["tier"]) {
                    section.appendChild(document.createElement("br"));
                    section.appendChild(document.createElement("br"));
                    section.appendChild(document.createElement("br"));
                    section.appendChild(document.createElement("br"));
                    section.appendChild(document.createElement("br"));
                    i = item["tier"];
                    if (j > temp) {
                        temp = j;
                    }
                    j = 0;
                }
                element.id = item["rankID"];
                element.value = item["rankName"];
                element.name = "rankButton";
                element.style.backgroundImage = "linear-gradient(to right, #314755 0%, #26a0da  51%, #314755  100%)";
                element.style.padding = "7px";
                element.style.textAlign = "center";
                element.style.transition = "0.5s";
                element.style.backgroundSize = "200% auto"
                element.style.color = "white";
                element.style.boxShadow = "0 0 20px #eee"
                element.style.fontSize = "14px";
                element.style.margin = "auto 25px auto auto";
                element.textContent = item["rankName"];
                if (playerRanks !== "Player not found") {
                    playerRanks.forEach((rank) => {
                        if ((rank['rankID'].toString().toLowerCase() === element.id) || (element.id === "default")) {
                            element.style.backgroundImage = "linear-gradient(to right, #870000 0%, #190A05  51%, #870000  100%)";
                            return false;
                        }
                    });
                }

                element.addEventListener("mouseover", () => hover(element));
                element.addEventListener("mouseout", () => normal(element));
                element.addEventListener("click", () => rankClick(element));
                section.appendChild(element);
            });
            maxTier = i + 1;
            maxRow = temp;
            document.getElementById("container").style.width = (maxRow * 100).toString() + "px";
            document.getElementById("container").style.height = (maxTier * 100).toString() + "px";
        });
    });
}

function normal(element) {
    element.style.backgroundPosition = "center center";
    element.style.color = "white";
}

function hover(element) {
    element.style.backgroundPosition = "right center";
    element.style.color = "#fff";
    element.style.textDecoration = "none";
}

function rankClick(element) {
    window.location.assign('./'+ element.id +'.html');
}