rankInfo();

function rankInfo() {
    fetch('/api/auth/session/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        let valid = await response.text();
        if (valid === "Invalid") {
            localStorage.removeItem("RaindropQuests");
        }
        if (localStorage.hasOwnProperty("RaindropQuests")) {
            fetch('/api/player/op/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                await response.text().then(op => {
                    fetch('/api/rank/info/?' + new URLSearchParams({
                        rank: document.location.pathname.toString().substring(1, document.location.pathname.toString().length - 5)
                    })).then(async (result) => {
                        await result.json().then(data => {

                            //Rank info
                            let rankInfoDiv = document.getElementById(`rankInfo`);
                            let p = document.createElement(`p`);
                            let name = document.createElement(`span`);
                            name.innerText = data[`rankName`];
                            name.style.fontWeight = `bold !important`;
                            p.appendChild(name);
                            if (op === `true`) {
                                p.innerText = p.innerText + ` (` + data[`rankID`] + `) ` + `\n`  +
                                    `GUI Button: ` + data[`material`] + `\n` +
                                    `Tier: ` + data[`tier`] + `\n` +
                                    `Prefix: ` + data[`prefix`] + `\n` +
                                    `Suffix: ` + data[`suffix`];
                            } else {
                                p.innerText = p.innerText + `\n` +
                                    `Tier: ` + data[`tier`] + `\n` +
                                    `Prefix: ` + data[`prefix`] + `\n` +
                                    `Suffix: ` + data[`suffix`];
                            }
                            rankInfoDiv.appendChild(p);
                            //Required ranks
                            let requiredList = document.createElement(`ul`);
                            let required = data[`requiredRank`];
                            required.forEach(item => {
                                let li = document.createElement("li");
                                li.innerText = item;
                                requiredList.appendChild(li);
                            });
                            let requiredFigure = document.createElement("figure");
                            let requiredCaption = document.createElement("figcaption");
                            requiredCaption.innerText = "Required Ranks";
                            requiredFigure.appendChild(requiredCaption)
                            requiredList.style.order = "2";
                            requiredList.style.overflowY = "auto";
                            requiredList.style.overflowX = "hidden";
                            requiredFigure.appendChild(requiredList);
                            requiredFigure.style.overflowY = "auto";
                            requiredFigure.style.height = "100%";
                            rankInfoDiv.appendChild(requiredFigure);


                            //Rank Lists
                            let rankListDiv = document.getElementById(`rankLists`);
                            let mcMMOList = document.createElement('ul');
                            let jobsList = document.createElement('ul');
                            let craftingList = document.createElement('ul');
                            let killsList = document.createElement('ul');
                            let commandsList = document.createElement('ul');
                            let mcMMO = data[`mcMMO`];
                            let jobs = data[`jobsReborn`];
                            let crafting = data[`craftingMap`];
                            let kills = data[`kills`];
                            let commands = data[`commands`];

                            mcMMO.forEach(item => {
                                let li = document.createElement("li");
                                li.innerText = item;
                                mcMMOList.appendChild(li);
                            });
                            let mcMMOFigure = document.createElement("figure");
                            let mcMMOCaption = document.createElement("figcaption");
                            mcMMOCaption.innerText = "mcMMO";
                            mcMMOFigure.appendChild(mcMMOCaption)
                            mcMMOList.style.order = "1";
                            mcMMOFigure.appendChild(mcMMOList);
                            mcMMOFigure.style.overflowY = "auto";
                            mcMMOFigure.style.height = "100%";
                            rankListDiv.appendChild(mcMMOFigure);

                            jobs.forEach(item => {
                                let li = document.createElement("li");
                                li.innerText = item;
                                jobsList.appendChild(li);
                            });
                            let jobsFigure = document.createElement("figure");
                            let jobsCaption = document.createElement("figcaption");
                            jobsCaption.innerText = "Jobs";
                            jobsFigure.appendChild(jobsCaption)
                            jobsList.style.order = "2";
                            jobsFigure.appendChild(jobsList);
                            jobsFigure.style.overflowY = "auto";
                            jobsFigure.style.height = "100%";
                            rankListDiv.appendChild(jobsFigure);

                            for (const key in crafting) {
                                if (crafting.hasOwnProperty(key)) {
                                    let li = document.createElement("li");
                                    li.innerText = key + ` : ` + crafting[key];
                                    craftingList.appendChild(li);
                                }
                            }
                            let craftingFigure = document.createElement("figure");
                            let craftingCaption = document.createElement("figcaption");
                            craftingCaption.innerText = "Crafting";
                            craftingFigure.appendChild(craftingCaption)
                            craftingList.style.order = "3";
                            craftingFigure.appendChild(craftingList);
                            craftingFigure.style.overflowY = "auto";
                            craftingFigure.style.height = "100%";
                            rankListDiv.appendChild(craftingFigure);


                            kills.forEach(item => {
                                let li = document.createElement("li");
                                li.innerText = item;
                                killsList.appendChild(li);
                            });
                            let killsFigure = document.createElement("figure");
                            let killsCaption = document.createElement("figcaption");
                            killsCaption.innerText = "Kills";
                            killsFigure.appendChild(killsCaption)
                            killsList.style.order = "4";
                            killsFigure.appendChild(killsList);
                            killsFigure.style.overflowY = "auto";
                            killsFigure.style.height = "100%";
                            rankListDiv.appendChild(killsFigure);

                            if (op === `true`) {
                                commands.forEach(item => {
                                    let li = document.createElement("li");
                                    li.innerText = item;
                                    commandsList.appendChild(li);
                                });
                                let commandsFigure = document.createElement("figure");
                                let commandsCaption = document.createElement("figcaption");
                                commandsCaption.innerText = "Commands";
                                commandsFigure.appendChild(commandsCaption)
                                commandsList.style.order = "4";
                                commandsFigure.appendChild(commandsList);
                                commandsFigure.style.overflowY = "auto";
                                commandsFigure.style.height = "100%";
                                rankListDiv.appendChild(commandsFigure);
                            }
                        })
                    });
                });
            });
        }
    });
}

function rankInfoOld() {
    fetch('/api/player/op/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        await response.text().then(op => {
            fetch('/api/rank/info/?' + new URLSearchParams({
                rank: document.location.pathname.toString().substring(1, document.location.pathname.toString().length - 5)
            })).then(async (result) => {
                let div = document.getElementById(`rankInfo`);
                let table = document.createElement("table");
                table.id = "ranks";
                table.class = "display";
                table.style.margin = "auto";
                let thead = table.createTHead();
                let tr = thead.insertRow();
                addHead(tr, "Rank Name");
                if (op === "true") {
                    addHead(tr, "Rank ID");
                }
                if (op === "true") {
                    addHead(tr, "Material");
                }
                if (op === "true") {
                    addHead(tr, "LuckPerms Group");
                }
                addHead(tr, "Prefix");
                addHead(tr, "Suffix");
                if (op === "true") {
                    addHead(tr, "Required Rank ID");
                }
                addHead(tr, "Required Rank Name");
                addHead(tr, "mcMMO");
                addHead(tr, "Cost");
                addHead(tr, "Path");
                if (op === "true") {
                    addHead(tr, "Path ID");
                }
                addHead(tr, "Jobs");
                addHead(tr, "Kills");
                if (op === "true") {
                    addHead(tr, "Commands");
                }
                div.appendChild(table);
                if (op === "true") {
                    addRanksOP(await result);
                } else {
                    addRanks(await result);
                }
            });
        });
    });
}