addPlayerQuests();
function addPlayerQuests() {
    fetch('/api/auth/session/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        let valid = await response.text();
        if (valid === "Invalid") {
            localStorage.removeItem("RaindropQuests");
        }
        if (localStorage.hasOwnProperty("RaindropQuests")) {
            fetch('/api/player/op/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                await response.text().then(op => {
                    fetch('/api/quests/info/?' + new URLSearchParams({
                        session: localStorage.getItem("RaindropQuests")
                    })).then(async (result) => {
                        fetch('/plugin/economy/symbol').then(async (data) => {
                            let symbol = await data.text();
                            console.log(symbol);
                            let div = document.getElementById(`questsWrapper`);
                            let table = document.createElement("table");
                            table.id = "quests";
                            table.class = "display";
                            table.style.margin = "auto";
                            let thead = table.createTHead();
                            let tr = thead.insertRow();
                            addHead(tr, "Quest Name");
                            if (op === "true") {
                                addHead(tr, "Quest ID");
                            }
                            if (op === "true") {
                                addHead(tr, "Material");
                            }
                            addHead(tr, "Lore");
                            addHead(tr, "Requirements");
                            addHead(tr, "Currency");
                            addHead(tr, "Vault");
                            addHead(tr, "Rewards");
                            addHead(tr, "Cool Down");
                            if (op === "true") {
                                addHead(tr, "Broadcast");
                            }
                            if (op === "true") {
                                addHead(tr, "Discord");
                            }
                            if (op === "true") {
                                addHead(tr, "Player");
                            }
                            if (op === "true") {
                                addHead(tr, "Logger");
                            }
                            if (op === "true") {
                                addHead(tr, "Completed Messages");
                            }
                            div.appendChild(table);

                            if (op === "true") {
                                console.log(symbol);
                                showQuestsOP(await result, symbol);
                            } else {
                                showQuests(await result, symbol);
                            }
                        });
                    });
                });
            });
        }
    });
}

function runPlaceholder(placeholder) {
    let a = document.getElementById(placeholder);
    fetch('/api/placeholder/run', {
        method: "POST",
        body: JSON.stringify({
            placeholder: placeholder,
            session : localStorage.getItem("RaindropQuests")
        }),
        headers: {
            "Content-type": "application/json; charset=UTF-8"
        }
    }).then(async result => {
        a.textContent = await result.text();
        a.title = "Click to run!";
        setTimeout(() => {
            a.textContent = placeholder;
        }, 5000);
    })
    console.log(placeholder);
}
function showQuestsOP(result, symbol) {
    let codes = ["&4", "&c", "&6", "&e", "&2", "&a", "&b", "&3", "&1", "&9", "&d", "&5", "&f", "&7", "&8", "&0", "&l", "&m", "&n", "&o"];
    $(document).ready(async function () {
        $('#quests').DataTable({
            data: JSON.parse(await result.text()),
            scrollX: true,
            dom: '<"toolbar">lfrtip',
            columns: [
                {
                    data: 'title',
                    render: function (data) {
                        let count = countOccurrences(data.toString(), `&`);
                        for (let i = 0; i < count; i++) {
                            let contain = false;
                            codes.some(element => {
                                if (data.includes(element)) {
                                    contain = true;
                                }
                            });
                            if (contain) {
                                data = replaceColorCodes(data.toString().trim());
                            }
                            //console.log(item);
                        }
                        return data;
                    }
                },
                {data: 'name'},
                {data: 'button'},
                {
                    data: 'lore',
                    render: function (data) {
                        let j = 0;
                        data.forEach(item => {
                            let count = countOccurrences(item.toString(), `&`);
                            for (let i = 0; i < count; i++) {
                                let contain = false;
                                codes.some(element => {
                                    if (item.includes(element)) {
                                        contain = true;
                                    }
                                });
                                if (contain) {
                                    item = replaceColorCodes(item.toString().trim());
                                }
                            }
                            data[j] = item;
                            j++;
                        });
                        return data.join(`<br>`);
                    }
                },
                {
                    data: 'requirements',
                    render: function (data) {
                        let send = "";
                        for (let name in data) {
                            if (name.toString().startsWith("PAPI")) {
                                let link = name.toString().substring(5);
                                send += name.substring(0, 5) + `<a id="` + link +
                                    `" href=javascript:runPlaceholder("` + link + `")>` + link +
                                    `</a>:` + data[name] + `<br>`;
                            } else {
                                send += name + ` : ` + data[name] + `<br>`;
                            }
                        }
                        return send;
                    }
                },
                {data: 'currency'},
                {
                    data: 'vault',
                    render: function (data) {
                        return symbol  + data;
                    }
                },
                {
                    data: 'rewards',
                    render: function (data) {
                        let send = "";
                        for (let name in data) {
                            send += name + ` : ` + data[name] + `<br>`;
                        }
                        return send;
                    }
                },
                {
                    data: 'coolDown'
                },
                {
                    data: 'broadcast'
                },
                {
                    data: 'discord'
                },
                {
                    data: 'player'
                },
                {
                    data: 'logger'
                },
                {
                    data: 'completedMessage',
                    render: function (data) {
                        return data.toString().trim().replaceAll(/,/g, "<br>");
                    }
                }
            ],
            columnDefs: [{
                targets: 1,
                className: 'text-nowrap'
            },{
                targets: 3,
                className: 'text-nowrap'
            },{
                targets: 4,
                className: 'text-nowrap'
            },{
                targets: 7,
                className: 'text-nowrap'
            },{
                targets: 13,
                className: 'text-nowrap'
            }]
    });
        $('div.toolbar').html('<b>Quests</b>');
    });
}

function showQuests(response, symbol) {
    let codes = ["&4", "&c", "&6", "&e", "&2", "&a", "&b", "&3", "&1", "&9", "&d", "&5", "&f", "&7", "&8", "&0", "&l", "&m", "&n", "&o"];
    $(document).ready(async function () {
        $('#quests').DataTable({
            data: JSON.parse(await response.text()),
            scrollX: true,
            dom: '<"toolbar">lfrtip',
            columns: [
                {
                    data: 'title',
                    render: function (data) {
                        let count = countOccurrences(data.toString(), `&`);
                        for (let i = 0; i < count; i++) {
                            let contain = false;
                            codes.some(element => {
                                if (data.includes(element)) {
                                    contain = true;
                                }
                            });
                            if (contain) {
                                data = replaceColorCodes(data.toString().trim());
                            }
                            //console.log(item);
                        }
                        return data;
                    }
                },
                {
                    data: 'lore',
                    render: function (data) {
                        let j = 0;
                        data.forEach(item => {
                            let count = countOccurrences(item.toString(), `&`);
                            for (let i = 0; i < count; i++) {
                                let contain = false;
                                codes.some(element => {
                                    if (item.includes(element)) {
                                        contain = true;
                                    }
                                });
                                if (contain) {
                                    item = replaceColorCodes(item.toString().trim());
                                }
                            }
                            data[j] = item;
                            j++;
                        });
                        return data.join(`<br>`);
                    }
                },
                {
                    data: 'requirements',
                    render: function (data) {
                        let send = "";
                        for (let name in data) {
                            send += name + ` : ` + data[name] + `<br>`;
                        }
                        return send;
                    }
                },
                {data: 'currency'},
                {
                    data: 'vault',
                    render: function (data) {
                        return symbol + data;
                    }
                },
                {
                    data: 'rewards',
                    render: function (data) {
                        let send = "";
                        for (let name in data) {
                            send += name + ` : ` + data[name] + `<br>`;
                        }
                        return send;
                    }
                },
                {
                    data: 'coolDown'
                }
            ]
        });
        $('div.toolbar').html('<b>Quests</b>');
    });
}