function getAvatar() {
    setHeaders();
    fetch('/api/player/avatar/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        const r = await response;
        const json = r.clone();
        if (await r.text() !== "Not a player") {
            await json.json().then(result => {
                let div = document.getElementById("headerLinks");
                let img = document.createElement("img");
                img.src = `https://cdn.discordapp.com/avatars/` + result["id"] + `/` + result["avatar"];
                img.style.width = "64px";
                img.style.height = "64px";
                img.style.order = "6";
                img.title = result["username"] + `#` + result["discriminator"];
                div.appendChild(img);
            })
        }
    }).catch(error => {
        console.log(error)
    })
}

function getPlayer() {
    fetch('/api/player/data/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        const r = await response;
        const json = r.clone();
        if (await r.text() !== "Not a player") {
            await json.json().then(result => {
                let div = document.getElementById("playerWrapper");
                let name = document.createElement(`p`);
                let uuid = document.createElement(`p`);
                let address = document.createElement(`p`);
                let highest = document.createElement(`p`);
                name.innerText = result["name"];
                uuid.innerText = result["uuid"];
                if (!result["address"].toString()) {
                    address.style.color = `#55FF55`;
                    address.innerText = `Online`;
                } else {
                    address.style.color = `#FF5555`;
                    address.innerText = result["address"];
                }
                highest.innerText = result["highest"];
                let imgLeft = document.createElement(`img`);
                let imgRight = document.createElement(`img`);
                imgLeft.src = `/assets/header.png`;
                imgRight.src = `/assets/header.png`;
                imgLeft.style.transform = `scaleX(-1)`;
                div.appendChild(imgLeft);
                div.appendChild(name);
                div.appendChild(uuid);
                div.appendChild(address);
                div.appendChild(highest);
                div.appendChild(imgRight);
            })
        }
    }).catch(error => {
        console.log(error)
    })
}
/*
function getPlayerPermissions() {
    fetch('/api/player/op/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        if (await response.text() === "true") {
            fetch('/api/player/permissions/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                const r = await response;
                const json = r.clone();
                if (await r.text() !== "Not a player") {
                    await json.json().then(result => {
                        let div = document.getElementById("permissions");
                        result.forEach(function (item) {
                            div.innerHTML += item + "\n";
                        });
                    });
                }
            }).catch(error => {
                console.log(error);
            });
        }
    });
}

function getPlayerRanks() {
    fetch('/api/player/op/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        await response.text().then( op => {
            fetch('/api/player/ranks/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                const r = await response;
                const json = r.clone();
                if (await r.text() !== "Not a player") {
                    await json.json().then(result => {
                        let table = document.getElementById("ranks");
                        let thead = table.createTHead();
                        let headerRow = thead.insertRow();
                        headerRow.style.fontSize = "20px";
                        headerRow.style.fontWeight = "bold";
                        addCell(headerRow, 'Rank Name');
                        if (op === "true") {
                            addCell(headerRow, 'Rank ID');
                        }
                        addCell(headerRow, 'Material');
                        if (op === "true") {
                            addCell(headerRow, 'LuckPerms Group');
                        }
                        addCell(headerRow, 'Prefix');
                        addCell(headerRow, 'Suffix');
                        addCell(headerRow, 'Required Ranks');
                        addCell(headerRow, 'mcMMO');
                        addCell(headerRow, 'Path');
                        addCell(headerRow, 'Cost');
                        addCell(headerRow, 'Jobs Reborn');
                        addCell(headerRow, 'Kills');
                        if (op === "true") {
                            addCell(headerRow, 'Commands');
                        }
                        result.forEach(function (item) {
                            let row = table.insertRow();
                            addCell(row, item["rankName"]);
                            if (op === "true") {
                                addCell(row, item["rankID"]);
                            }
                            addCell(row, item["material"]);
                            if (op === "true") {
                                addCell(row, item["luckPermGroup"]);
                            }
                            addCell(row, item["prefix"]);
                            addCell(row, item["suffix"]);
                            addCellArray(row, item["requiredRank"]);
                            addCellArray(row, item["mcMMO"]);
                            addCellArray(row, item["path"]);
                            addCellArray(row, item["cost"]);
                            addCellArray(row, item["jobsReborn"]);
                            addCellArray(row, item["kills"]);
                            if (op === "true") {
                                addCellArray(row, item["commands"]);
                            }
                        });
                    });
                }
            }).catch(error => {
                console.log(error);
            });
        });
    });
}
 */