getPlayerKills();
function getPlayerKills() {
    function addHead(tr, text) {
        let th = document.createElement("th");
        th.textContent = text;
        tr.appendChild(th);
        return th;
    }
    getBosses().then(bosses => {
        if (localStorage.hasOwnProperty("RaindropQuests")) {
            fetch('/api/player/kills/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                const r = await response;
                const json = r.clone();
                if (await r.text() !== "Not a player") {
                    await json.json().then(async mobs => {
                        let div = document.getElementById(`killsWrapper`);
                        let table = document.createElement("table");
                        table.id = "kills";
                        table.class = "display";
                        //table.style.width = "80%";
                        table.style.margin = "auto";
                        let thead = table.createTHead();
                        let tr = thead.insertRow();
                        addHead(tr, "Entity");
                        addHead(tr, "Kills");
                        div.appendChild(table);
                        $(document).ready(async function () {
                            let datatable = $('#kills').DataTable({
                                dom: '<"toolbar">lfrtip',
                                columns: [
                                    {
                                        "data": "key",
                                        "title": "Entity"
                                    },
                                    {
                                        "data": "value",
                                        "title": "Value"
                                    }
                                ]
                            });

                            $('div.toolbar').html('<b>Kills</b>');

                            for (const key in mobs) {
                                if (mobs.hasOwnProperty(key)) {
                                    if (bosses.includes(key)) {
                                        await datatable.row.add({
                                            "key": key,
                                            "value": mobs[key]
                                        }).draw().nodes().to$().addClass(`dark_red`);
                                    } else {
                                        await datatable.row.add({
                                            "key": key,
                                            "value": mobs[key]
                                        }).draw();
                                    }
                                }
                            }
                        });
                    });
                }
            }).catch(error => {
                console.log(error);
            });
        }
    });
}

function getBosses() {
    return fetch('/api/bosses/info').then(async (response) => {
        return await response.json().then(result => {
            return result;
        });
    });
}