addPlayerRanks();
function addPlayerRanks() {
    fetch('/api/auth/session/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        let valid = await response.text();
        if (valid === "Invalid") {
            localStorage.removeItem("RaindropQuests");
        }
        if (localStorage.hasOwnProperty("RaindropQuests")) {
            fetch('/api/player/op/?' + new URLSearchParams({
                session: localStorage.getItem("RaindropQuests")
            })).then(async (response) => {
                await response.text().then(op => {
                    fetch('/api/player/ranks/?' + new URLSearchParams({
                        session: localStorage.getItem("RaindropQuests")
                    })).then(async (result) => {
                        let res = result.clone();
                        if (await res.text() !== "Not a player") {
                            if (localStorage.hasOwnProperty("RaindropQuests")) {
                                let div = document.getElementById(`ranksWrapper`);
                                let table = document.createElement("table");
                                table.id = "ranks";
                                table.class = "display";
                                //table.style.width = "80%";
                                table.style.margin = "auto";
                                let thead = table.createTHead();
                                let tr = thead.insertRow();
                                addHead(tr, "Rank Name");
                                if (op === "true") {
                                    addHead(tr, "Rank ID");
                                }
                                if (op === "true") {
                                    addHead(tr, "Material");
                                }
                                if (op === "true") {
                                    addHead(tr, "LuckPerms Group");
                                }
                                addHead(tr, "Prefix");
                                addHead(tr, "Suffix");
                                if (op === "true") {
                                    addHead(tr, "Required Rank ID");
                                }
                                addHead(tr, "Required Rank Name");
                                addHead(tr, "mcMMO");
                                addHead(tr, "Cost");
                                addHead(tr, "Path Name");
                                if (op === "true") {
                                    addHead(tr, "Path ID");
                                }
                                addHead(tr, "Jobs");
                                addHead(tr, "Kills");
                                if (op === "true") {
                                    addHead(tr, "Commands");
                                }
                                div.appendChild(table);
                                if (op === "true") {
                                    addRanksOP(await result);
                                } else {
                                    addRanks(await result);
                                }
                            }
                        }
                    });
                });
            });
        }
    });
}