window.addEventListener("DOMContentLoaded",async function() {
    fetch('/api/auth/session/?' + new URLSearchParams({
        session: localStorage.getItem("RaindropQuests")
    })).then(async (response) => {
        if (document.location.pathname !== "/auth.html") {
            let valid = await response.text();
            if (valid === "Invalid") {
                localStorage.removeItem("RaindropQuests");
            }
            if (localStorage.getItem("RaindropQuests") === null) {
                let div = document.getElementById("headerLinks");
                let a = document.createElement("a");
                fetch("/api/auth/url").then(async (response) => {
                    a.setAttribute('href', await response.text());
                }).catch(error => {
                    console.log(error);
                });
                let img = document.createElement("img");
                if (document.location.pathname !== '/tree.html') {
                    img.src = "/assets/login.png";
                    img.style.position = "fixed";
                    img.style.top = "50%";
                    img.style.left = "50%";
                    img.style.transform = "translate(-50%, -50%)"
                    img.style.height = "auto";
                    img.style.width = "auto";
                    img.style.maxWidth = "70%";
                    img.style.maxHeight = "70%";
                } else {
                    img.src = "/assets/discord.png";
                    img.style.width = "64px";
                    img.style.height = "64px";
                    a.style.order = "7";
                    a.style.display = "flex";
                }
                div.style.textAlign = "center";
                div.title = "Discord Login";
                a.appendChild(img);
                div.appendChild(a);
            } else {
                let div = document.getElementById("headerLinks");
                let a = document.createElement("a");
                a.setAttribute('href', "javascript:remove();");
                a.addEventListener('click', function remove() {
                    fetch("/api/auth/remove/?" + new URLSearchParams({
                        session: localStorage.getItem("RaindropQuests")
                    })).then(async (response) => {
                        localStorage.removeItem("RaindropQuests");
                        document.location.reload();
                    }).catch(error => {
                        console.log(error);
                    });
                });
                let img = document.createElement("img");
                if (document.location.pathname === '/login.html') {
                    document.location.href = "/index.html";
                }
                img.src = "/assets/logout.png";
                img.style.width = "64px";
                img.style.height = "64px";
                img.title = "Logout";
                a.style.order = "7";
                a.appendChild(img);
                div.appendChild(a);
            }
        }
        const params = new URLSearchParams(window.location.search);
        const code = params.get('code');
        if (code) {
            fetch('/api/auth/discord')
                .then(async result => result.json())
                .then(async response => {
                    const {Client_ID, Client_Secret, Redirect_URL} = await response;
                    fetch('https://discord.com/api/oauth2/token', {
                        headers: {
                            'content-type': 'application/x-www-form-urlencoded',
                        },
                        method: 'POST',
                        body: new URLSearchParams({
                            client_id: Client_ID,
                            client_secret: Client_Secret,
                            code: code,
                            grant_type: 'authorization_code',
                            redirect_uri: Redirect_URL,
                            scope: 'identify',
                        }).toString()
                    }).then(data => data.json()).then(user => {
                        fetch('https://discord.com/api/users/@me', {
                            headers: {
                                authorization: user['token_type'] + ` ` + user['access_token'],
                            },
                        })
                            .then(result => result.json())
                            .then(response => {
                                const {id, username, discriminator, avatar} = response;
                                fetch('/api/player/uuid').then(async (response) => {
                                    const rand = await response.text();
                                    localStorage.setItem("RaindropQuests", rand);
                                    sendJSON(id, username, discriminator, rand, avatar);
                                    document.getElementById('info').innerText = ` ${username}#${discriminator}`;
                                    document.location.href = "/index.html";
                                });
                            })
                            .catch(console.error);
                    })
                });
        } else if (document.location.pathname === "/auth.html") {
            document.location.href = "/index.html";
        }
    });
});

function sendJSON(id, user, disc, rand, avatar) {
    fetch('/api/player/discord', {
        method: "POST",
        body: JSON.stringify({
            id: id,
            username: user,
            discriminator: disc,
            session: rand,
            avatar: avatar
        }),
        headers: {
            "Content-type": "application/json; charset=UTF-8"
        }
    }).then((response) => console.log(response));
}